package dev.codeflush.baseencoder.compatibility;

import java.io.*;

public enum StandardSchemas implements Schema<Void>, TypedSchema<Object> {

    JAVA {
        @Override
        public void serialize(Void typeInformation, Object object, OutputStream out) throws IOException {
            serialize(object, out);
        }

        @Override
        public <T> T deserialize(Void typeInformation, InputStream in) throws IOException {
            return (T) deserialize(in);
        }

        @Override
        public void serialize(Object object, OutputStream out) throws IOException {
            new ObjectOutputStream(out).writeObject(object);
        }

        @Override
        public Object deserialize(InputStream in) throws IOException {
            try {
                return new ObjectInputStream(in).readObject();
            } catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }
    };
}
