/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.api.authentication.internal;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import com.google.gson.Gson;
import dev.galasa.framework.spi.IFramework;
import java.io.IOException;
import java.security.Principal;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(service={Servlet.class}, scope=ServiceScope.PROTOTYPE, property={"osgi.http.whiteboard.servlet.pattern=/auth"}, configurationPid={"dev.galasa"}, configurationPolicy=ConfigurationPolicy.REQUIRE, name="Galasa Authentication")
public class Authenticate
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static String SECRET_KEY = "framework.jwt.secret";
    private static long FOUR_HOURS_EXPIRE = 14400000L;
    @Reference
    public IFramework framework;
    private final Properties configurationProperties = new Properties();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Gson gson = new Gson();
        Principal principal = req.getUserPrincipal();
        if (principal == null) {
            resp.setStatus(401);
            resp.addHeader("WWW-Authenticate", "Basic realm=\"Galasa\"");
            resp.getWriter().write("Requires authentication");
            return;
        }
        if (req.isUserInRole("admin")) {
            String jwt;
            try {
                jwt = this.createJWT(principal.getName(), "admin", FOUR_HOURS_EXPIRE);
            }
            catch (JWTCreationException e) {
                resp.setStatus(500);
                resp.addHeader("WWW-Authenticate", "Basic realm=\"Galasa\"");
                resp.getWriter().write("Token could not be generated");
                return;
            }
            AuthJson auth = new AuthJson();
            auth.cps = jwt;
            auth.dss = jwt;
            auth.ras = jwt;
            String json = gson.toJson((Object)auth);
            resp.setContentType("application/json");
            try {
                resp.getWriter().write(json);
            }
            catch (IOException e) {
                resp.setStatus(500);
                resp.addHeader("WWW-Authenticate", "Basic realm=\"Galasa\"");
                resp.getWriter().write("Failed to create json");
                return;
            }
            return;
        }
        if (req.isUserInRole("user")) {
            String jwt;
            try {
                jwt = this.createJWT(principal.getName(), "user", FOUR_HOURS_EXPIRE);
            }
            catch (JWTCreationException e) {
                resp.setStatus(500);
                resp.addHeader("WWW-Authenticate", "Basic realm=\"Galasa\"");
                resp.getWriter().write("Token could not be generated");
                return;
            }
            AuthJson auth = new AuthJson();
            auth.cps = jwt;
            auth.dss = jwt;
            auth.ras = jwt;
            String json = gson.toJson((Object)auth);
            resp.setContentType("application/json");
            try {
                resp.getWriter().write(json);
            }
            catch (IOException e) {
                resp.setStatus(500);
                resp.addHeader("WWW-Authenticate", "Basic realm=\"Galasa\"");
                resp.getWriter().write("Failed to create json");
                return;
            }
            return;
        }
        resp.setStatus(401);
        resp.addHeader("WWW-Authenticate", "Basic realm=\"Galasa\"");
        resp.getWriter().write("Does not have the 'user' role");
    }

    public String createJWT(String subject, String role, long expireDuration) throws JWTCreationException {
        Algorithm algorithm = Algorithm.HMAC256((String)this.configurationProperties.get(SECRET_KEY).toString());
        long time = System.currentTimeMillis();
        Date dateNow = new Date(time);
        Date dateExpire = new Date(time + expireDuration);
        String token = JWT.create().withIssuer("galasa").withIssuedAt(dateNow).withSubject(subject).withClaim("role", role).withExpiresAt(dateExpire).sign(algorithm);
        return token;
    }

    @Activate
    public void activate(Map<String, Object> properties) {
        this.modified(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Modified
    public void modified(Map<String, Object> properties) {
        Properties properties2 = this.configurationProperties;
        synchronized (properties2) {
            String secret = (String)properties.get(SECRET_KEY);
            if (secret != null) {
                this.configurationProperties.put(SECRET_KEY, secret);
            } else {
                this.configurationProperties.remove(SECRET_KEY);
            }
        }
    }

    @Deactivate
    void deactivate() {
        this.configurationProperties.clear();
    }

    private class AuthJson {
        protected String cps;
        protected String dss;
        protected String ras;

        private AuthJson() {
        }
    }
}

