/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.api.authentication.internal;

import dev.galasa.framework.spi.IFramework;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(service={Servlet.class}, scope=ServiceScope.PROTOTYPE, property={"osgi.http.whiteboard.servlet.pattern=/authrefresh"}, configurationPid={"dev.galasa"}, configurationPolicy=ConfigurationPolicy.REQUIRE, name="Galasa Authentication Refresh")
public class AuthenticateRefresh
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    @Reference
    public IFramework framework;
    private final Properties configurationProperties = new Properties();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Principal principal = req.getUserPrincipal();
        if (principal == null) {
            resp.setStatus(401);
            resp.addHeader("WWW-Authenticate", "Bearer realm=\"Galasa\"");
            resp.getWriter().write("Requires JWT Token");
            return;
        }
        if (!req.isUserInRole("user")) {
            resp.setStatus(401);
            resp.addHeader("WWW-Authenticate", "Bearer realm=\"Galasa\"");
            resp.getWriter().write("Does not have the 'user' role");
            return;
        }
        resp.setStatus(503);
        resp.setContentType("text/plain");
        resp.getWriter().write("James hasn't written the code yet");
    }

    @Activate
    void activate(Map<String, Object> properties) {
        this.modified(properties);
    }

    @Modified
    void modified(Map<String, Object> properties) {
    }

    @Deactivate
    void deactivate() {
    }
}

