/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.api.authentication.internal;

import dev.galasa.framework.api.authentication.internal.RequestWrapper;
import java.io.IOException;
import java.security.Principal;
import java.util.Base64;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ServiceScope;

@Component(service={Filter.class}, scope=ServiceScope.PROTOTYPE, property={"osgi.http.whiteboard.filter.pattern=/auth"}, name="Galasa Basic Auth")
public class BasicAuthFilter
implements Filter {
    private final Log logger = LogFactory.getLog(this.getClass());

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        HttpServletResponse servletResponse = (HttpServletResponse)response;
        Principal principal = servletRequest.getUserPrincipal();
        if (principal != null) {
            chain.doFilter(request, response);
            return;
        }
        String authorization = servletRequest.getHeader("Authorization");
        if (authorization == null) {
            chain.doFilter(request, response);
            return;
        }
        StringTokenizer st = new StringTokenizer(authorization);
        if (!st.hasMoreTokens()) {
            chain.doFilter(request, response);
            return;
        }
        String basic = st.nextToken();
        if (!"basic".equalsIgnoreCase(basic)) {
            chain.doFilter(request, response);
            return;
        }
        if (!st.hasMoreTokens()) {
            chain.doFilter(request, response);
            return;
        }
        String credentials = new String(Base64.getDecoder().decode(st.nextToken()));
        String[] parts = credentials.split(":");
        if (parts.length != 2) {
            this.invalidAuth(servletRequest, servletResponse);
            return;
        }
        final String username = parts[0].trim();
        final String password = parts[1].trim();
        CallbackHandler callbackHandler = new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        NameCallback nc = (NameCallback)callback;
                        nc.setName(username);
                        continue;
                    }
                    if (!(callback instanceof PasswordCallback)) continue;
                    PasswordCallback pc = (PasswordCallback)callback;
                    pc.setPassword(password.toCharArray());
                }
            }
        };
        Subject subject = null;
        try {
            LoginContext ctx = new LoginContext("galasa", callbackHandler);
            ctx.login();
            subject = ctx.getSubject();
        }
        catch (LoginException e) {
            this.invalidAuth(servletRequest, servletResponse);
            this.logger.info((Object)("Authentication failed for user '" + username + "'"), (Throwable)e);
            return;
        }
        if (subject == null) {
            this.invalidAuth(servletRequest, servletResponse);
            return;
        }
        String name = null;
        HashSet<String> roles = new HashSet<String>();
        for (Principal p : subject.getPrincipals()) {
            String pName = p.getClass().getName();
            if (pName.endsWith(".UserPrincipal")) {
                name = p.getName();
                continue;
            }
            if (!pName.endsWith(".RolePrincipal")) continue;
            roles.add(p.getName());
        }
        if (name == null) {
            name = username;
        }
        RequestWrapper wrapper = new RequestWrapper(name.toLowerCase(), roles, servletRequest);
        chain.doFilter((ServletRequest)wrapper, response);
    }

    private void invalidAuth(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        servletResponse.setStatus(401);
        servletResponse.addHeader("WWW-Authenticate", "Basic realm=\"Galasa\"");
        servletResponse.getWriter().write("Invalid authentication");
    }

    public void destroy() {
    }
}

