/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.api.authentication.internal;

import com.auth0.jwt.JWT;
import com.auth0.jwt.exceptions.JWTDecodeException;
import dev.galasa.framework.spi.IFramework;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(service={Servlet.class}, scope=ServiceScope.PROTOTYPE, property={"osgi.http.whiteboard.servlet.pattern=/auth/identity"}, name="Galasa Identity")
public class Identity
extends HttpServlet {
    @Reference
    public IFramework framework;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String subject;
        response.setContentType("text/plain");
        String jwt = this.getBearerToken(request);
        try {
            subject = JWT.decode((String)jwt).getSubject();
        }
        catch (JWTDecodeException e) {
            response.setStatus(500);
            response.addHeader("WWW-Authenticate", "Basic realm=\"Galasa\"");
            response.getWriter().write("Failed to decode token");
            return;
        }
        if (request.isUserInRole("admin")) {
            try {
                response.getWriter().write(subject + " is in admin\n");
            }
            catch (IOException e) {
                response.setStatus(500);
                response.addHeader("WWW-Authenticate", "Basic realm=\"Galasa\"");
                response.getWriter().write("Failed to write");
                return;
            }
            return;
        }
        if (request.isUserInRole("user")) {
            try {
                response.getWriter().write(subject + " is a user\n");
            }
            catch (IOException e) {
                response.setStatus(500);
                response.addHeader("WWW-Authenticate", "Basic realm=\"Galasa\"");
                response.getWriter().write("Failed to write");
                return;
            }
            return;
        }
        response.addHeader("WWW-Authenticate", "Basic realm=\"Galasa\"");
        response.getWriter().write("No authetication!\n");
    }

    private String getBearerToken(HttpServletRequest request) {
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null && authHeader.startsWith("Bearer")) {
            return authHeader.substring("bearer".length());
        }
        return null;
    }
}

