/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.docker.controller;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.command.PullImageResultCallback;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import dev.galasa.framework.FrameworkInitialisation;
import dev.galasa.framework.docker.controller.DockerControllerException;
import dev.galasa.framework.docker.controller.Health;
import dev.galasa.framework.docker.controller.Heartbeat;
import dev.galasa.framework.docker.controller.RunDeleted;
import dev.galasa.framework.docker.controller.RunPoll;
import dev.galasa.framework.docker.controller.Settings;
import dev.galasa.framework.spi.FrameworkException;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IFramework;
import io.prometheus.client.exporter.HTTPServer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;

@Component(service={DockerController.class})
public class DockerController {
    private Log logger = LogFactory.getLog(this.getClass());
    private boolean shutdown = false;
    private boolean shutdownComplete = false;
    private ScheduledExecutorService scheduledExecutorService;
    private HTTPServer metricsServer;
    private Health healthServer;

    public void run(Properties bootstrapProperties, Properties overrideProperties) throws FrameworkException {
        Settings settings;
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        FrameworkInitialisation frameworkInitialisation = null;
        try {
            frameworkInitialisation = new FrameworkInitialisation(bootstrapProperties, overrideProperties);
        }
        catch (Exception e) {
            throw new FrameworkException("Unable to initialise the Framework Services", (Throwable)e);
        }
        IFramework framework = frameworkInitialisation.getFramework();
        IConfigurationPropertyStoreService cps = framework.getConfigurationPropertyService("framework");
        IDynamicStatusStoreService dss = framework.getDynamicStatusStoreService("framework");
        this.logger.info((Object)"Starting Docker Controller");
        try {
            settings = new Settings();
        }
        catch (MalformedURLException e) {
            throw new DockerControllerException("Unable to initialise settings", e);
        }
        int metricsPort = 9010;
        int healthPort = 9011;
        String port = DockerController.nulled(cps.getProperty("controller.metrics", "port", new String[0]));
        if (port != null) {
            metricsPort = Integer.parseInt(port);
        }
        if ((port = DockerController.nulled(cps.getProperty("controller.health", "port", new String[0]))) != null) {
            healthPort = Integer.parseInt(port);
        }
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(3);
        this.scheduledExecutorService.scheduleWithFixedDelay(new Heartbeat(dss, settings), 0L, 20L, TimeUnit.SECONDS);
        this.scheduledExecutorService.scheduleWithFixedDelay(settings, 20L, 20L, TimeUnit.SECONDS);
        if (metricsPort > 0) {
            try {
                this.metricsServer = new HTTPServer(metricsPort);
                this.logger.info((Object)("Metrics server running on port " + metricsPort));
            }
            catch (IOException e) {
                throw new DockerControllerException("Unable to start the metrics server", e);
            }
        } else {
            this.logger.info((Object)"Metrics server disabled");
        }
        if (healthPort > 0) {
            this.healthServer = new Health(healthPort);
            this.logger.info((Object)("Health monitoring on port " + healthPort));
        } else {
            this.logger.info((Object)"Health monitoring disabled");
        }
        DefaultDockerClientConfig config = DefaultDockerClientConfig.createDefaultConfigBuilder().build();
        ApacheDockerHttpClient httpClient = new ApacheDockerHttpClient.Builder().dockerHost(config.getDockerHost()).sslConfig((SSLConfig)config.getSSLConfig()).build();
        DockerClient dockerClient = DockerClientImpl.getInstance((DockerClientConfig)config, (DockerHttpClient)httpClient);
        try {
            dockerClient.pingCmd().exec();
        }
        catch (Exception e) {
            throw new DockerControllerException("Problem contacting the Docker engine", e);
        }
        this.getImageId(dockerClient, settings.getEngineImage());
        RunDeleted runDeleted = new RunDeleted(settings, dockerClient, framework.getFrameworkRuns());
        this.scheduledExecutorService.scheduleWithFixedDelay(runDeleted, 0L, settings.getRunPoll(), TimeUnit.SECONDS);
        RunPoll runPoll = new RunPoll(dss, settings, dockerClient, framework.getFrameworkRuns());
        this.scheduledExecutorService.scheduleWithFixedDelay(runPoll, 1L, settings.getRunPoll(), TimeUnit.SECONDS);
        this.logger.info((Object)"Docker controller has started");
        while (!this.shutdown) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                throw new DockerControllerException("Interrupted sleep", e);
            }
        }
        this.scheduledExecutorService.shutdown();
        try {
            this.scheduledExecutorService.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to shutdown the scheduler");
        }
        if (metricsPort > 0) {
            this.metricsServer.stop();
        }
        if (healthPort > 0) {
            this.healthServer.shutdown();
        }
        this.logger.info((Object)"Docker Controller shutdown");
        this.shutdownComplete = true;
    }

    public static String nulled(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).isEmpty()) {
            return value;
        }
        return value;
    }

    protected String getImageId(DockerClient dockerClient, String imageName) throws DockerControllerException {
        try {
            InspectImageResponse response = dockerClient.inspectImageCmd(imageName).exec();
            return response.getId();
        }
        catch (NotFoundException e) {
            try {
                System.out.println("Pulling image '" + imageName + "'");
                PullImageCmd cmd = dockerClient.pullImageCmd(imageName);
                PullImageResultCallback callback = new PullImageResultCallback();
                cmd.exec((ResultCallback)callback);
                if (!callback.awaitCompletion(5L, TimeUnit.MINUTES)) {
                    throw new DockerControllerException("Timed out pulling '" + imageName + "' image");
                }
                InspectImageResponse response = dockerClient.inspectImageCmd(imageName).exec();
                return response.getId();
            }
            catch (Exception e1) {
                throw new DockerControllerException("Problem pulling '" + imageName + "' image", e1);
            }
        }
        catch (Exception e) {
            throw new DockerControllerException("Problem inspecting '" + imageName + "' image", e);
        }
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            DockerController.this.logger.info((Object)"Shutdown request received");
            DockerController.this.shutdown = true;
            while (!DockerController.this.shutdownComplete) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    DockerController.this.logger.info((Object)"Shutdown wait was interrupted", (Throwable)e);
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }
}

