/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.docker.controller;

import dev.galasa.framework.docker.controller.Settings;
import dev.galasa.framework.spi.DynamicStatusStoreException;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import java.time.Instant;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Heartbeat
implements Runnable {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Settings settings;
    private final IDynamicStatusStoreService dss;

    public Heartbeat(IDynamicStatusStoreService dss, Settings settings) {
        this.dss = dss;
        this.settings = settings;
    }

    @Override
    public void run() {
        Instant time = Instant.now();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("servers.controller." + this.settings.getPodName() + ".heartbeat", time.toString());
        try {
            this.dss.put(props);
        }
        catch (DynamicStatusStoreException e) {
            this.logger.error((Object)"Problem logging heartbeat", (Throwable)e);
        }
    }
}

