/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.docker.controller;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Container;
import dev.galasa.framework.docker.controller.RunPoll;
import dev.galasa.framework.docker.controller.Settings;
import dev.galasa.framework.spi.IFrameworkRuns;
import dev.galasa.framework.spi.IRun;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RunDeleted
implements Runnable {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Settings settings;
    private final DockerClient dockerClient;
    private final IFrameworkRuns runs;

    public RunDeleted(Settings settings, DockerClient dockerClient, IFrameworkRuns runs) {
        this.settings = settings;
        this.dockerClient = dockerClient;
        this.runs = runs;
    }

    @Override
    public void run() {
        this.logger.info((Object)"Starting Deleted runs scan");
        try {
            List<Container> containers = RunPoll.getContainers(this.dockerClient, this.settings);
            RunPoll.filterTerminated(containers);
            for (Container container : containers) {
                IRun run;
                String runName = (String)container.getLabels().get("galasaRun");
                if (runName == null || (run = this.runs.getRun(runName)) != null) continue;
                this.logger.info((Object)("Deleting container " + container.getNames()[0] + " as run has been deleted"));
                this.deleteContainer(container);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Problem with Deleted runs scan", (Throwable)e);
        }
    }

    private void deleteContainer(Container container) {
        try {
            this.logger.info((Object)("Deleting container " + container.getNames()[0] + " id " + container.getId()));
            this.dockerClient.removeContainerCmd(container.getId()).withForce(Boolean.valueOf(true)).exec();
        }
        catch (NotFoundException notFoundException) {
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to delete engine pod", (Throwable)e);
        }
    }
}

