/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.docker.controller;

import java.io.ByteArrayInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Settings
implements Runnable {
    private final Log logger = LogFactory.getLog(this.getClass());
    private URL configFileUrl;
    private String bootstrap = "http://galasa-api:8181/bootstrap";
    private String containername;
    private String engineLabel = "none";
    private String engineImage = "none";
    private int engineMemory = 100;
    private int engineMemoryRequest = 150;
    private int engineMemoryLimit = 200;
    private String network = "";
    private ArrayList<String> dnsList = new ArrayList();
    private HashSet<String> requiredCapabilities = new HashSet();
    private HashSet<String> capableCapabilities = new HashSet();
    private String reportCapabilties = null;
    private int runPoll = 20;
    private int runPollRecheck = 1;
    private int maxEngines = 0;
    private ArrayList<String> requestorsByScheduleID = new ArrayList();
    private String oldConfigFile = null;

    public Settings() throws MalformedURLException {
        this.loadEnvironmentProperties();
        this.retrieveConfigFile();
    }

    @Override
    public void run() {
        this.retrieveConfigFile();
    }

    private void retrieveConfigFile() {
        String newRunPoll;
        Properties properties = new Properties();
        try {
            Path configPath = Paths.get(this.configFileUrl.toURI());
            String newConfigFile = "";
            if (Files.exists(configPath, new LinkOption[0])) {
                newConfigFile = new String(Files.readAllBytes(configPath), "utf-8");
            }
            if (newConfigFile.equals(this.oldConfigFile)) {
                return;
            }
            this.oldConfigFile = newConfigFile;
            this.logger.info((Object)"Config File has been changed, reloading parameters");
            properties.load(new ByteArrayInputStream(newConfigFile.getBytes()));
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to read the config file", (Throwable)e);
            return;
        }
        try {
            String newBootstrap = properties.getProperty("bootstrap");
            if (newBootstrap == null || newBootstrap.trim().isEmpty()) {
                newBootstrap = "http://galasa-api:8181/bootstrap";
            }
            if (!newBootstrap.equals(this.bootstrap)) {
                this.logger.info((Object)("Setting Boostrap from '" + this.bootstrap + "' to '" + newBootstrap + "'"));
                this.bootstrap = newBootstrap;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error processing bootstrap in configfile", (Throwable)e);
        }
        try {
            int newMaxEngines;
            String maxEnginesString = properties.getProperty("max_engines");
            if (maxEnginesString == null || maxEnginesString.trim().isEmpty()) {
                maxEnginesString = "2";
            }
            if ((newMaxEngines = Integer.parseInt(maxEnginesString)) != this.maxEngines) {
                this.logger.info((Object)("Setting Max Engines from " + this.maxEngines + " to " + newMaxEngines));
                this.maxEngines = newMaxEngines;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error processing max_engines in configfile", (Throwable)e);
        }
        try {
            String newEngineLabel = properties.getProperty("engine_label");
            if (newEngineLabel == null || newEngineLabel.trim().isEmpty()) {
                newEngineLabel = "docker_standard_engine";
            }
            if (!newEngineLabel.equals(this.engineLabel)) {
                this.logger.info((Object)("Setting Engine Label from '" + this.engineLabel + "' to '" + newEngineLabel + "'"));
                this.engineLabel = newEngineLabel;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error processing engine_label in configfile", (Throwable)e);
        }
        try {
            String newEngineImage = properties.getProperty("engine_image");
            if (newEngineImage == null || newEngineImage.trim().isEmpty()) {
                newEngineImage = "galasadev/galasa-boot-embedded-amd64:latest";
            }
            if (!newEngineImage.equals(this.engineImage)) {
                this.logger.info((Object)("Setting Engine Image from '" + this.engineImage + "' to '" + newEngineImage + "'"));
                this.engineImage = newEngineImage;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error processing engine_image in configfile", (Throwable)e);
        }
        try {
            Integer memory;
            String newEngineMemory = properties.getProperty("engine_memory");
            if (newEngineMemory == null || newEngineMemory.trim().isEmpty()) {
                newEngineMemory = "300";
            }
            if ((memory = Integer.valueOf(Integer.parseInt(newEngineMemory))) != this.engineMemory) {
                this.logger.info((Object)("Setting Engine Memory from '" + this.engineMemory + "' to '" + memory + "'"));
                this.engineMemory = memory;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error processing engine_memory in configfile", (Throwable)e);
        }
        try {
            Integer memory;
            String newEngineMemoryRequest = properties.getProperty("engine_memory_request");
            if (newEngineMemoryRequest == null || newEngineMemoryRequest.trim().isEmpty()) {
                newEngineMemoryRequest = Integer.toString(this.engineMemory + 50);
            }
            if ((memory = Integer.valueOf(Integer.parseInt(newEngineMemoryRequest))) != this.engineMemoryRequest) {
                this.logger.info((Object)("Setting Engine Memory Request from '" + this.engineMemoryRequest + "' to '" + memory + "'"));
                this.engineMemoryRequest = memory;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error processing engine_memory_request in configfile", (Throwable)e);
        }
        try {
            Integer memory;
            String newEngineMemoryLimit = properties.getProperty("engine_memory_limit");
            if (newEngineMemoryLimit == null || newEngineMemoryLimit.trim().isEmpty()) {
                newEngineMemoryLimit = Integer.toString(this.engineMemory + 100);
            }
            if ((memory = Integer.valueOf(Integer.parseInt(newEngineMemoryLimit))) != this.engineMemoryLimit) {
                this.logger.info((Object)("Setting Engine Memory Limit from '" + this.engineMemoryLimit + "' to '" + memory + "'"));
                this.engineMemoryLimit = memory;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error processing engine_memory_limit in configfile", (Throwable)e);
        }
        try {
            Integer poll;
            newRunPoll = properties.getProperty("run_poll");
            if (newRunPoll == null || newRunPoll.trim().isEmpty()) {
                newRunPoll = "20";
            }
            if ((poll = Integer.valueOf(Integer.parseInt(newRunPoll))) != this.runPoll) {
                this.logger.info((Object)("Setting Run Poll from '" + this.runPoll + "' to '" + poll + "'"));
                this.runPoll = poll;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error processing run_poll in configfile", (Throwable)e);
        }
        try {
            Integer poll;
            newRunPoll = properties.getProperty("run_poll_recheck");
            if (newRunPoll == null || newRunPoll.trim().isEmpty()) {
                newRunPoll = "1";
            }
            if ((poll = Integer.valueOf(Integer.parseInt(newRunPoll))) != this.runPollRecheck) {
                this.logger.info((Object)("Setting Run Poll Recheck from '" + this.runPollRecheck + "' to '" + poll + "'"));
                this.runPollRecheck = poll;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error processing run_poll_recheck in configfile", (Throwable)e);
        }
        try {
            String[] requestors;
            String newRequestors = properties.getProperty("scheduled_requestors");
            if (newRequestors == null || newRequestors.trim().isEmpty()) {
                newRequestors = "";
            }
            ArrayList<String> newRequestorsByScheduleid = new ArrayList<String>();
            for (String requestor : requestors = newRequestors.split(",")) {
                newRequestorsByScheduleid.add(requestor);
            }
            if (!this.requestorsByScheduleID.equals(newRequestorsByScheduleid)) {
                this.logger.info((Object)("Setting Requestors by Schedule from '" + this.requestorsByScheduleID + "' to '" + newRequestorsByScheduleid + "'"));
                this.requestorsByScheduleID = newRequestorsByScheduleid;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error processing scheduled_requestors in configfile", (Throwable)e);
        }
        try {
            String[] capabalities;
            String newCapabilities = properties.getProperty("engine_capabilities");
            if (newCapabilities == null || newCapabilities.trim().isEmpty()) {
                newCapabilities = "";
            }
            ArrayList<String> newRequiredCapabilties = new ArrayList<String>();
            ArrayList<String> newCapableCapabilties = new ArrayList<String>();
            for (String capability : capabalities = newCapabilities.split(",")) {
                if ((capability = capability.trim()).startsWith("+")) {
                    if ((capability = capability.substring(1)).isEmpty()) continue;
                    newRequiredCapabilties.add(capability);
                    continue;
                }
                if (capability.isEmpty()) continue;
                newCapableCapabilties.add(capability);
            }
            boolean changed = false;
            if (newRequiredCapabilties.size() != this.requiredCapabilities.size() || newCapableCapabilties.size() != this.capableCapabilities.size()) {
                changed = true;
            } else {
                for (String cap : newCapableCapabilties) {
                    if (this.capableCapabilities.contains(cap)) continue;
                    changed = true;
                    break;
                }
                for (String cap : newRequiredCapabilties) {
                    if (this.requiredCapabilities.contains(cap)) continue;
                    changed = true;
                    break;
                }
            }
            if (changed) {
                this.capableCapabilities.clear();
                this.requiredCapabilities.clear();
                this.capableCapabilities.addAll(newCapableCapabilties);
                this.requiredCapabilities.addAll(newRequiredCapabilties);
                this.logger.info((Object)("Engine set with Required Capabilities - " + this.requiredCapabilities));
                this.logger.info((Object)("Engine set with Capabable Capabilities - " + this.capableCapabilities));
                StringBuilder report = new StringBuilder();
                for (String cap : this.requiredCapabilities) {
                    if (report.length() > 0) {
                        report.append(",");
                    }
                    report.append("+");
                    report.append(cap);
                }
                for (String cap : this.capableCapabilities) {
                    if (report.length() > 0) {
                        report.append(",");
                    }
                    report.append(cap);
                }
                this.reportCapabilties = report.length() > 0 ? report.toString() : null;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error processing engine_capabilities in configfile", (Throwable)e);
        }
    }

    private void loadEnvironmentProperties() throws MalformedURLException {
        this.containername = System.getenv("CONTAINERNAME");
        this.containername = this.containername == null || this.containername.trim().isEmpty() ? "docker-controller" : this.containername.trim();
        this.logger.info((Object)("Setting Container Name to '" + this.containername + "'"));
        String sConfigFileUrl = System.getenv("CONFIG");
        sConfigFileUrl = sConfigFileUrl == null || sConfigFileUrl.trim().isEmpty() ? "file:/etc/galasa.properties" : sConfigFileUrl.trim();
        this.logger.info((Object)("Setting Config File Url to '" + this.configFileUrl + "'"));
        this.configFileUrl = new URL(sConfigFileUrl);
    }

    public String getPodName() {
        return this.containername;
    }

    public String getEngineLabel() {
        return this.engineLabel;
    }

    public int getMaxEngines() {
        return this.maxEngines;
    }

    public List<String> getRequestorsByGroup() {
        return this.requestorsByScheduleID;
    }

    public String getEngineImage() {
        return this.engineImage;
    }

    public int getEngineMemoryRequest() {
        return this.engineMemoryRequest;
    }

    public int getEngineMemoryLimit() {
        return this.engineMemoryLimit;
    }

    public int getEngineMemory() {
        return this.engineMemory;
    }

    public String getBootstrap() {
        return this.bootstrap;
    }

    public int getRunPoll() {
        return this.runPoll;
    }

    public int getRunPollRecheck() {
        return this.runPollRecheck;
    }

    public List<String> getDns() {
        return this.dnsList;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getReportCapabilities() {
        return this.reportCapabilties;
    }
}

