/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.docker.controller;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.ListContainersCmd;
import com.github.dockerjava.api.exception.ConflictException;
import com.github.dockerjava.api.model.Container;
import dev.galasa.framework.docker.controller.DockerControllerException;
import dev.galasa.framework.docker.controller.Settings;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IFrameworkRuns;
import dev.galasa.framework.spi.IRun;
import io.prometheus.client.Counter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RunPoll
implements Runnable {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Settings settings;
    private final DockerClient dockerClient;
    private final IDynamicStatusStoreService dss;
    private final IFrameworkRuns runs;
    private final QueuedComparator queuedComparator = new QueuedComparator();
    private Counter submittedRuns;

    public RunPoll(IDynamicStatusStoreService dss, Settings settings, DockerClient dockerClient, IFrameworkRuns runs) {
        this.settings = settings;
        this.dockerClient = dockerClient;
        this.runs = runs;
        this.dss = dss;
        this.submittedRuns = (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name("galasa_docker_controller_submitted_runs")).help("The number of runs submitted by the Docker controller")).register();
    }

    @Override
    public void run() {
        this.logger.info((Object)"Looking for new runs");
        try {
            List queuedRuns = this.runs.getQueuedRuns();
            Iterator queuedRunsIterator = queuedRuns.iterator();
            while (queuedRunsIterator.hasNext()) {
                IRun run = (IRun)queuedRunsIterator.next();
                if (!run.isLocal()) continue;
                queuedRunsIterator.remove();
            }
            if (queuedRuns.isEmpty()) {
                this.logger.info((Object)"There are no queued runs");
                return;
            }
            while (true) {
                List<Container> pods = RunPoll.getContainers(this.dockerClient, this.settings);
                RunPoll.filterActiveRuns(pods);
                this.logger.info((Object)("Active runs=" + pods.size() + ",max=" + this.settings.getMaxEngines()));
                int currentActive = pods.size();
                if (currentActive >= this.settings.getMaxEngines()) {
                    this.logger.info((Object)("Not looking for runs, currently at maximim engines (" + this.settings.getMaxEngines() + ")"));
                    return;
                }
                Collections.sort(queuedRuns, this.queuedComparator);
                IRun selectedRun = (IRun)queuedRuns.remove(0);
                this.startPod(selectedRun);
                if (queuedRuns.isEmpty()) break;
                Thread.sleep((long)this.settings.getRunPollRecheck() * 1000L);
            }
            return;
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to poll for new runs", (Throwable)e);
            return;
        }
    }

    private void startPod(IRun run) {
        String runName = run.getName();
        String engineName = this.settings.getEngineLabel() + "_" + runName.toLowerCase();
        this.logger.info((Object)("Received run " + runName));
        String containerId = null;
        try {
            CreateContainerCmd cmd;
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("run." + runName + ".controller", this.settings.getPodName());
            if (!this.dss.putSwap("run." + runName + ".status", "queued", "allocated", props)) {
                this.logger.info((Object)"run allocated by another controller");
                return;
            }
            String choosenEngineName = engineName;
            boolean successful = false;
            int retry = 0;
            while (!successful) {
                try {
                    cmd = this.dockerClient.createContainerCmd(choosenEngineName);
                    cmd.withName(choosenEngineName);
                    cmd.withImage(this.settings.getEngineImage());
                    HashMap<String, String> labels = new HashMap<String, String>();
                    labels.put("galasaEngineController", this.settings.getEngineLabel());
                    labels.put("galasaRun", runName);
                    cmd.withLabels(labels);
                    ArrayList<String> cmds = new ArrayList<String>();
                    cmds.add("java");
                    cmds.add("-jar");
                    cmds.add("boot.jar");
                    cmds.add("--obr");
                    cmds.add("file:galasa.obr");
                    cmds.add("--bootstrap");
                    cmds.add(this.settings.getBootstrap());
                    cmds.add("--run");
                    cmds.add(runName);
                    if (run.isTrace()) {
                        cmds.add("--trace");
                    }
                    cmd.withCmd(cmds);
                    CreateContainerResponse response = cmd.exec();
                    containerId = response.getId();
                    this.logger.info((Object)("Engine Container " + engineName + " created with id " + containerId));
                    successful = true;
                    break;
                }
                catch (ConflictException e) {
                    choosenEngineName = engineName + "_" + ++retry;
                    this.logger.info((Object)("Engine Pod " + engineName + " already exists, trying with " + choosenEngineName));
                }
                catch (Exception e) {
                    throw new DockerControllerException("Container create failed", e);
                }
                this.logger.info((Object)"Waiting 2 seconds before trying to create container again");
                Thread.sleep(2000L);
            }
            successful = false;
            while (!successful) {
                try {
                    cmd = this.dockerClient.startContainerCmd(containerId);
                    cmd.exec();
                    this.logger.info((Object)("Engine Container " + choosenEngineName + " started with id " + containerId));
                    successful = true;
                    this.submittedRuns.inc();
                    break;
                }
                catch (Exception e) {
                    this.logger.error((Object)"Failed to start engine container", (Throwable)e);
                    this.logger.info((Object)"Waiting 2 seconds before trying to start container again");
                    Thread.sleep(2000L);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to start new engine", (Throwable)e);
        }
    }

    @NotNull
    public static List<Container> getContainers(DockerClient dockerClient, Settings settings) throws DockerControllerException {
        try {
            ListContainersCmd cmd = dockerClient.listContainersCmd();
            cmd.withShowAll(Boolean.valueOf(true));
            ArrayList<String> labels = new ArrayList<String>();
            labels.add("galasaEngineController=" + settings.getEngineLabel());
            cmd.withLabelFilter(labels);
            List possibleContainers = (List)cmd.exec();
            ArrayList<Container> containers = new ArrayList<Container>(possibleContainers.size());
            if (possibleContainers != null) {
                for (Container container : possibleContainers) {
                    Map containerLabels = container.getLabels();
                    if (containerLabels == null || !containerLabels.containsKey("galasaRun")) continue;
                    containers.add(container);
                }
            }
            return containers;
        }
        catch (Exception e) {
            throw new DockerControllerException("Problem listing the engine containers", e);
        }
    }

    public static void filterActiveRuns(@NotNull List<Container> containers) {
        Iterator<Container> iContainer = containers.iterator();
        while (iContainer.hasNext()) {
            Container container = iContainer.next();
            if (!"exited".equals(container.getState())) continue;
            iContainer.remove();
        }
    }

    public static void filterTerminated(@NotNull List<Container> containers) {
        Iterator<Container> iContainer = containers.iterator();
        while (iContainer.hasNext()) {
            Container container = iContainer.next();
            if ("exited".equals(container.getState())) continue;
            iContainer.remove();
        }
    }

    private static class QueuedComparator
    implements Comparator<IRun> {
        private QueuedComparator() {
        }

        @Override
        public int compare(IRun o1, IRun o2) {
            return o1.getQueued().compareTo(o2.getQueued());
        }
    }
}

