/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.plugins.nonnull;

import dev.hilla.parser.core.AbstractPlugin;
import dev.hilla.parser.core.Node;
import dev.hilla.parser.core.NodeDependencies;
import dev.hilla.parser.core.NodePath;
import dev.hilla.parser.core.Plugin;
import dev.hilla.parser.core.PluginConfiguration;
import dev.hilla.parser.models.AnnotatedModel;
import dev.hilla.parser.models.AnnotationInfoModel;
import dev.hilla.parser.models.ClassInfoModel;
import dev.hilla.parser.models.PackageInfoModel;
import dev.hilla.parser.plugins.backbone.BackbonePlugin;
import dev.hilla.parser.plugins.nonnull.AnnotationMatcher;
import dev.hilla.parser.plugins.nonnull.NonnullPluginConfig;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class NonnullPlugin
extends AbstractPlugin<NonnullPluginConfig> {
    private Map<String, AnnotationMatcher> annotationsMap = NonnullPlugin.mapByName(NonnullPluginConfig.Processor.defaults);

    public NonnullPlugin() {
        this.setOrder(100);
    }

    @Nonnull
    public NodeDependencies scan(@Nonnull NodeDependencies nodeDependencies) {
        return nodeDependencies;
    }

    public void enter(NodePath<?> nodePath) {
    }

    public void exit(NodePath<?> nodePath) {
        Node parentNode;
        if (!(nodePath.getNode().getTarget() instanceof Schema)) {
            return;
        }
        Schema schema = (Schema)nodePath.getNode().getTarget();
        Stream<AnnotationInfoModel> annotations = this.getPackageAnnotationsStream(nodePath);
        if (nodePath.getNode().getSource() instanceof AnnotatedModel) {
            annotations = Stream.concat(annotations, ((AnnotatedModel)nodePath.getNode().getSource()).getAnnotationsStream());
        }
        if ((parentNode = nodePath.getParentPath().getNode()).getSource() instanceof AnnotatedModel && !(parentNode.getTarget() instanceof Schema)) {
            annotations = Stream.concat(annotations, ((AnnotatedModel)parentNode.getSource()).getAnnotationsStream());
        }
        annotations.map(annotation -> this.annotationsMap.get(annotation.getName())).filter(Objects::nonNull).max(Comparator.comparingInt(AnnotationMatcher::getScore)).map(AnnotationMatcher::doesMakeNullable).ifPresent(nullable -> schema.setNullable(nullable != false ? Boolean.valueOf(true) : null));
    }

    public void setConfiguration(@Nonnull PluginConfiguration configuration) {
        super.setConfiguration(configuration);
        this.annotationsMap = NonnullPlugin.mapByName(new NonnullPluginConfig.Processor((NonnullPluginConfig)this.getConfiguration()).process());
    }

    public Collection<Class<? extends Plugin>> getRequiredPlugins() {
        return List.of(BackbonePlugin.class);
    }

    private Optional<PackageInfoModel> findClosestPackage(NodePath<?> nodePath) {
        return nodePath.stream().map(NodePath::getNode).filter(node -> node.getSource() instanceof ClassInfoModel).map(node -> (ClassInfoModel)node.getSource()).findFirst().map(ClassInfoModel::getPackage);
    }

    private Stream<AnnotationInfoModel> getPackageAnnotationsStream(NodePath<?> nodePath) {
        return this.findClosestPackage(nodePath).stream().flatMap(AnnotatedModel::getAnnotationsStream);
    }

    private static Map<String, AnnotationMatcher> mapByName(Collection<AnnotationMatcher> annotations) {
        return annotations.stream().collect(Collectors.toMap(AnnotationMatcher::getName, Function.identity()));
    }
}

