/*
 * Decompiled with CFR 0.152.
 */
package dev.hitools.utils.core;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.text.TextUtils;
import dev.hitools.utils.base.provider.InitProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0010\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\u0007\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ldev/hitools/utils/core/AppUtils;", "", "()V", "TAG", "", "VERSION_CODE", "VERSION_NAME", "isFastDoubleClick", "", "isFastDoubleClick$annotations", "()Z", "sLastClickTime", "", "getAppName", "context", "Landroid/content/Context;", "getLauncherApp", "", "getUserApps", "getVersionCode", "packageName", "getVersionName", "isInstall", "pkgName", "utils-core_release"})
public final class AppUtils {
    @NotNull
    public static final AppUtils INSTANCE = new AppUtils();
    @NotNull
    private static final String TAG = "AppUtils";
    @NotNull
    public static final String VERSION_CODE = "cache_saved_version_code";
    @NotNull
    public static final String VERSION_NAME = "cache_saved_version_name";
    private static long sLastClickTime;

    private AppUtils() {
    }

    public static final boolean isFastDoubleClick() {
        long currentTime = System.currentTimeMillis();
        long timeDiffer = currentTime - sLastClickTime;
        boolean bl = 1L <= timeDiffer ? timeDiffer < 301L : false;
        if (bl) {
            return true;
        }
        sLastClickTime = currentTime;
        return false;
    }

    @JvmStatic
    public static /* synthetic */ void isFastDoubleClick$annotations() {
    }

    @JvmStatic
    public static final long getVersionCode(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
        return AppUtils.getVersionCode(context, string);
    }

    @JvmStatic
    public static final long getVersionCode(@NotNull Context context, @NotNull String packageName) {
        long l;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        try {
            l = Build.VERSION.SDK_INT >= 28 ? context.getPackageManager().getPackageInfo(packageName, 128).getLongVersionCode() : (long)context.getPackageManager().getPackageInfo((String)packageName, (int)128).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            l = 0L;
        }
        return l;
    }

    @JvmStatic
    @NotNull
    public static final String getVersionName(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
        return AppUtils.getVersionName(context, string);
    }

    @JvmStatic
    @NotNull
    public static final String getVersionName(@NotNull Context context, @NotNull String packageName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        try {
            String string2 = context.getPackageManager().getPackageInfo((String)packageName, (int)128).versionName;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            context.pa\u2026TA).versionName\n        }");
            string = string2;
        }
        catch (Exception e) {
            e.printStackTrace();
            string = "";
        }
        return string;
    }

    @JvmStatic
    @Nullable
    public static final String getAppName(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            int labelRes = packageInfo.applicationInfo.labelRes;
            return context.getString(labelRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @JvmStatic
    @NotNull
    public static final Map<String, String> getUserApps(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List list = context.getPackageManager().getInstalledPackages(0);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"context.packageManager.getInstalledPackages(0)");
        List packages = list;
        HashMap apps = new HashMap();
        for (PackageInfo packageInfo : packages) {
            String string;
            String string2;
            if ((packageInfo.applicationInfo.flags & 1) != 0 || TextUtils.equals((CharSequence)packageInfo.packageName, (CharSequence)context.getPackageName())) continue;
            Map map = apps;
            Intrinsics.checkNotNullExpressionValue((Object)packageInfo.packageName, (String)"packageInfo.packageName");
            Intrinsics.checkNotNullExpressionValue((Object)packageInfo.versionName, (String)"packageInfo.versionName");
            map.put(string2, string);
        }
        return apps;
    }

    @JvmStatic
    @NotNull
    public static final Map<String, String> getLauncherApp(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PackageManager packageManager = context.getPackageManager();
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.LAUNCHER");
        List list = packageManager.queryIntentActivities(intent, 0);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"packageManager.queryIntentActivities(intent, 0)");
        List resolveInfoList = list;
        HashMap apps = new HashMap();
        for (ResolveInfo resolveInfo : resolveInfoList) {
            CharSequence charSequence = resolveInfo.loadLabel(packageManager);
            Intrinsics.checkNotNull((Object)charSequence, (String)"null cannot be cast to non-null type kotlin.String");
            String title = (String)charSequence;
            Map map = apps;
            String string = resolveInfo.activityInfo.packageName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resolveInfo.activityInfo.packageName");
            map.put(string, title);
        }
        return apps;
    }

    public final boolean isInstall(@Nullable String pkgName) {
        boolean bl;
        if (pkgName == null || ((CharSequence)pkgName).length() == 0) {
            return false;
        }
        try {
            InitProvider.Companion.getApp().getPackageManager().getPackageInfo(pkgName, 0);
            bl = true;
        }
        catch (PackageManager.NameNotFoundException e) {
            bl = false;
        }
        return bl;
    }
}

