/*
 * Decompiled with CFR 0.152.
 */
package dev.hitools.utils.core;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u0010\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u0018\u00010\u00042\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bJ \u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bJ6\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00012\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00052\b\b\u0002\u0010\u0015\u001a\u00020\u0016J=\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u000b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u00a2\u0006\u0002\u0010\u0017JE\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u00a2\u0006\u0002\u0010\u0018J=\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0010J5\u0010\u001d\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u00a2\u0006\u0002\u0010\u001eJ\u001e\u0010\u001f\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u0001J&\u0010\u001f\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u0001J\u001e\u0010!\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0001J\u001e\u0010#\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u0001\u00a8\u0006$"}, d2={"Ldev/hitools/utils/core/ReflectionUtils;", "", "()V", "getClassTypes", "", "Ljava/lang/Class;", "args", "([Ljava/lang/Object;)[Ljava/lang/Class;", "getField", "owner", "fieldName", "", "className", "getObjectInArray", "array", "index", "", "getStaticField", "invokeMethod", "methodName", "argClasses", "showLog", "", "(Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;[Ljava/lang/Class;)Ljava/lang/Object;", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;[Ljava/lang/Class;)Ljava/lang/Object;", "invokeStaticMethod", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;[Ljava/lang/Class;)Ljava/lang/Object;", "newArrayInstance", "len", "newInstance", "(Ljava/lang/String;[Ljava/lang/Object;[Ljava/lang/Class;)Ljava/lang/Object;", "setField", "value", "setObjectInArray", "", "setStaticField", "utils-core_release"})
public final class ReflectionUtils {
    @NotNull
    public static final ReflectionUtils INSTANCE = new ReflectionUtils();

    private ReflectionUtils() {
    }

    @Nullable
    public final Class<?>[] getClassTypes(@Nullable Object[] args) {
        if (args == null || args.length == 0) {
            return null;
        }
        Class[] argClasses = new Class[args.length];
        int n = args.length;
        for (int i = 0; i < n; ++i) {
            argClasses[i] = args[i].getClass();
        }
        return argClasses;
    }

    @Nullable
    public final Object newInstance(@NotNull String className, @NotNull Object[] args, @NotNull Class<?>[] argClasses) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter(argClasses, (String)"argClasses");
        Object instance = null;
        try {
            Class<?> classObj = Class.forName(className);
            Constructor<?> cons = classObj.getConstructor(Arrays.copyOf(argClasses, argClasses.length));
            instance = cons.newInstance(Arrays.copyOf(args, args.length));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return instance;
    }

    @Nullable
    public final Object getStaticField(@NotNull String className, @NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Object fieldValue = null;
        try {
            Class<?> classObj = Class.forName(className);
            Field field = classObj.getDeclaredField(fieldName);
            field.setAccessible(true);
            fieldValue = field.get(null);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return fieldValue;
    }

    public final boolean setStaticField(@NotNull String className, @NotNull String fieldName, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean result = false;
        try {
            Class<?> classObj = Class.forName(className);
            Field field = classObj.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(null, value);
            result = true;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Nullable
    public final Object getField(@NotNull Object owner, @NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Object fieldValue = null;
        try {
            Class<?> classObj = owner.getClass();
            Field field = classObj.getDeclaredField(fieldName);
            field.setAccessible(true);
            fieldValue = field.get(owner);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return fieldValue;
    }

    @Nullable
    public final Object getField(@NotNull Object owner, @NotNull String className, @NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Object fieldValue = null;
        try {
            Class<?> classObj = Class.forName(className);
            Field field = classObj.getDeclaredField(fieldName);
            field.setAccessible(true);
            fieldValue = field.get(owner);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return fieldValue;
    }

    public final boolean setField(@NotNull Object owner, @NotNull String fieldName, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean result = false;
        try {
            Class<?> classObj = owner.getClass();
            Field field = classObj.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(owner, value);
            result = true;
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return result;
    }

    public final boolean setField(@NotNull Object owner, @NotNull String className, @NotNull String fieldName, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean result = false;
        try {
            Class<?> classObj = Class.forName(className);
            Field field = classObj.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(owner, value);
            result = true;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Nullable
    public final Object invokeStaticMethod(@NotNull String className, @NotNull String methodName, @NotNull Object[] args, @NotNull Class<?>[] argClasses) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter(argClasses, (String)"argClasses");
        Object result = null;
        try {
            Class<?> classObj = Class.forName(className);
            Method method = classObj.getDeclaredMethod(methodName, Arrays.copyOf(argClasses, argClasses.length));
            method.setAccessible(true);
            result = method.invoke(null, Arrays.copyOf(args, args.length));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Nullable
    public final Object invokeMethod(@NotNull Object owner, @NotNull String methodName, @NotNull Object[] args, @NotNull Class<?>[] argClasses) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter(argClasses, (String)"argClasses");
        Object result = null;
        try {
            Class<?> classObj = owner.getClass();
            Method method = classObj.getDeclaredMethod(methodName, Arrays.copyOf(argClasses, argClasses.length));
            method.setAccessible(true);
            result = method.invoke(owner, Arrays.copyOf(args, args.length));
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Nullable
    public final Object invokeMethod(@NotNull Object owner, @NotNull String methodName, @NotNull Object args, @NotNull Class<?> argClasses, boolean showLog) {
        Object result;
        block6: {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Intrinsics.checkNotNullParameter(argClasses, (String)"argClasses");
            result = null;
            try {
                Class<?> classObj = owner.getClass();
                Object[] objectArray = new Class[]{argClasses};
                Method method = classObj.getDeclaredMethod(methodName, (Class<?>[])objectArray);
                method.setAccessible(true);
                objectArray = new Object[]{args};
                result = method.invoke(owner, objectArray);
            }
            catch (NoSuchMethodException e) {
                if (showLog) {
                    e.printStackTrace();
                }
            }
            catch (InvocationTargetException e) {
                if (showLog) {
                    e.printStackTrace();
                }
            }
            catch (IllegalAccessException e) {
                if (!showLog) break block6;
                e.printStackTrace();
            }
        }
        return result;
    }

    public static /* synthetic */ Object invokeMethod$default(ReflectionUtils reflectionUtils, Object object, String string, Object object2, Class clazz, boolean bl, int n, Object object3) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        return reflectionUtils.invokeMethod(object, string, object2, clazz, bl);
    }

    @Nullable
    public final Object invokeMethod(@NotNull Object owner, @NotNull String className, @NotNull String methodName, @NotNull Object[] args, @NotNull Class<?>[] argClasses) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter(argClasses, (String)"argClasses");
        Object result = null;
        try {
            Class<?> classObj = Class.forName(className);
            Method method = classObj.getDeclaredMethod(methodName, Arrays.copyOf(argClasses, argClasses.length));
            method.setAccessible(true);
            result = method.invoke(owner, Arrays.copyOf(args, args.length));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Nullable
    public final Object newArrayInstance(@NotNull String className, int len) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Object result = null;
        try {
            Class<?> classObj = Class.forName(className);
            result = Array.newInstance(classObj, len);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Nullable
    public final Object getObjectInArray(@NotNull Object array, int index) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        return Array.get(array, index);
    }

    public final void setObjectInArray(@NotNull Object array, int index, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Array.set(array, index, value);
    }
}

