/*
 * Decompiled with CFR 0.152.
 */
package dev.hitools.utils.core;

import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\f\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u0010\u0010\n\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/hitools/utils/core/RegexValidateUtils;", "", "()V", "EMAIL_PATTERN", "", "ID_CARD_PATTERN", "PHONE_PATTERN", "checkBankCard", "", "bankCard", "checkEmail", "email", "checkIdCard", "idCard", "checkMobileNumber", "number", "getBankCardCheckCode", "", "nonCheckCodeBankCard", "utils-core_release"})
public final class RegexValidateUtils {
    @NotNull
    public static final RegexValidateUtils INSTANCE = new RegexValidateUtils();
    @NotNull
    private static final String EMAIL_PATTERN = "^(\\w)+(\\.\\w+)*@(\\w)+((\\.\\w{2,3}){1,3})$";
    @NotNull
    private static final String PHONE_PATTERN = "^((1[3-9][0-9])\\d{8})$";
    @NotNull
    private static final String ID_CARD_PATTERN = "([0-9]{17}([0-9]|X))|([0-9]{15})";

    private RegexValidateUtils() {
    }

    public final boolean checkEmail(@Nullable String email) {
        boolean bl;
        String[] stringArray = (String[])email;
        if (stringArray == null || StringsKt.isBlank((CharSequence)stringArray) || !StringsKt.contains$default((CharSequence)email, (CharSequence)"@", (boolean)false, (int)2, null)) {
            return false;
        }
        stringArray = new String[]{"@"};
        if (StringsKt.split$default((CharSequence)email, (String[])stringArray, (boolean)false, (int)0, (int)6, null).size() != 2) {
            return false;
        }
        try {
            bl = Pattern.matches(EMAIL_PATTERN, email);
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    public final boolean checkMobileNumber(@Nullable String number) {
        boolean bl;
        CharSequence charSequence = number;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || number.length() != 11) {
            return false;
        }
        String checkNumber = StringsKt.replace$default((String)number, (String)" ", (String)"", (boolean)false, (int)4, null);
        try {
            bl = Pattern.matches(PHONE_PATTERN, checkNumber);
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    public final boolean checkIdCard(@Nullable String idCard) {
        boolean bl;
        CharSequence charSequence = idCard;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return false;
        }
        if (idCard.length() != 15 && idCard.length() != 18) {
            return false;
        }
        try {
            bl = Pattern.matches(ID_CARD_PATTERN, idCard);
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    public final boolean checkBankCard(@NotNull String bankCard) {
        Intrinsics.checkNotNullParameter((Object)bankCard, (String)"bankCard");
        if (bankCard.length() < 15 || bankCard.length() > 19) {
            return false;
        }
        String string = bankCard.substring(0, bankCard.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        char bit = this.getBankCardCheckCode(string);
        return bit == 'N' ? false : bankCard.charAt(bankCard.length() - 1) == bit;
    }

    private final char getBankCardCheckCode(String nonCheckCodeBankCard) {
        CharSequence charSequence = nonCheckCodeBankCard;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || !new Regex("\\d+").matches(charSequence = (CharSequence)nonCheckCodeBankCard)) {
            return 'N';
        }
        String $this$trim$iv = nonCheckCodeBankCard;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        char[] cArray = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString().toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        char[] chs = cArray;
        int luhmSum = 0;
        int i = chs.length - 1;
        int j = 0;
        while (i >= 0) {
            int k = chs[i] - 48;
            if (j % 2 == 0) {
                k *= 2;
                k = k / 10 + k % 10;
            }
            luhmSum += k;
            --i;
            ++j;
        }
        return luhmSum % 10 == 0 ? (char)'0' : (char)(10 - luhmSum % 10 + 48);
    }
}

