/*
 * Decompiled with CFR 0.152.
 */
package dev.hitools.utils.core.glide.corner;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.RectF;
import android.graphics.Shader;
import android.os.Build;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import com.bumptech.glide.util.Preconditions;
import com.bumptech.glide.util.Util;
import dev.hitools.utils.kts.IntExt;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0003\u001d\u001e\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0004J\b\u0010\u0011\u001a\u00020\u0003H\u0016J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0014J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ldev/hitools/utils/core/glide/corner/GlideCorner;", "Lcom/bumptech/glide/load/resource/bitmap/BitmapTransformation;", "roundingRadius", "", "position", "Ldev/hitools/utils/core/glide/corner/GlideCorner$Position;", "(ILdev/hitools/utils/core/glide/corner/GlideCorner$Position;)V", "getPosition", "()Ldev/hitools/utils/core/glide/corner/GlideCorner$Position;", "radius", "equals", "", "other", "", "fixRect", "Landroid/graphics/RectF;", "originRect", "hashCode", "transform", "Landroid/graphics/Bitmap;", "pool", "Lcom/bumptech/glide/load/engine/bitmap_recycle/BitmapPool;", "toTransform2", "outWidth", "outHeight", "updateDiskCacheKey", "", "messageDigest", "Ljava/security/MessageDigest;", "Companion", "NoLock", "Position", "utils-core_release"})
public final class GlideCorner
extends BitmapTransformation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Position position;
    private final int radius;
    @NotNull
    private static final String ID = "dev.hitools.utils.core.glide.corner.GlideCorner";
    @NotNull
    private static final byte[] ID_BYTES;
    @NotNull
    private static final NoLock BITMAP_DRAWABLE_LOCK;

    public GlideCorner(int roundingRadius, @NotNull Position position) {
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        this.position = position;
        this.radius = IntExt.INSTANCE.dp2px(roundingRadius);
        Preconditions.checkArgument((roundingRadius > 0 ? 1 : 0) != 0, (String)"radius must be greater than 0.");
    }

    public /* synthetic */ GlideCorner(int n, Position position, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            position = Position.All;
        }
        this(n, position);
    }

    @NotNull
    public final Position getPosition() {
        return this.position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Bitmap transform(@NotNull BitmapPool pool, @NotNull Bitmap toTransform2, int outWidth, int outHeight) {
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        Intrinsics.checkNotNullParameter((Object)toTransform2, (String)"toTransform2");
        Preconditions.checkArgument((this.radius > 0 ? 1 : 0) != 0, (String)"radius must be greater than 0.");
        Bitmap.Config safeConfig = GlideCorner.Companion.getAlphaSafeConfig(toTransform2);
        Bitmap toTransform = GlideCorner.Companion.getAlphaSafeBitmap(pool, toTransform2);
        Bitmap bitmap = pool.get(toTransform.getWidth(), toTransform.getHeight(), safeConfig);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"pool.get(toTransform.wid\u2026sform.height, safeConfig)");
        Bitmap result = bitmap;
        result.setHasAlpha(true);
        BitmapShader shader = new BitmapShader(toTransform, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setShader((Shader)shader);
        RectF rect = new RectF(0.0f, 0.0f, (float)result.getWidth(), (float)result.getHeight());
        BITMAP_DRAWABLE_LOCK.lock();
        try {
            rect = this.fixRect(rect);
            Canvas canvas = new Canvas(result);
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
            canvas.drawRoundRect(rect, (float)this.radius, (float)this.radius, paint);
            GlideCorner.Companion.clear(canvas);
        }
        finally {
            BITMAP_DRAWABLE_LOCK.unlock();
        }
        if (!Intrinsics.areEqual((Object)toTransform, (Object)toTransform2)) {
            pool.put(toTransform);
        }
        return result;
    }

    @NotNull
    protected final RectF fixRect(@NotNull RectF originRect) {
        Intrinsics.checkNotNullParameter((Object)originRect, (String)"originRect");
        RectF rect = new RectF(originRect);
        switch (WhenMappings.$EnumSwitchMapping$0[this.position.ordinal()]) {
            case 1: {
                rect.bottom = originRect.bottom + (float)this.radius;
                break;
            }
            case 2: {
                rect.top = originRect.top - (float)this.radius;
                break;
            }
            case 3: {
                rect.right = originRect.right + (float)this.radius;
                break;
            }
            case 4: {
                rect.left = originRect.left - (float)this.radius;
                break;
            }
            case 5: {
                rect.right = originRect.right + (float)this.radius;
                rect.bottom = originRect.bottom + (float)this.radius;
                break;
            }
            case 6: {
                rect.bottom = originRect.bottom + (float)this.radius;
                rect.left = originRect.left - (float)this.radius;
                break;
            }
            case 7: {
                rect.top = originRect.top - (float)this.radius;
                rect.right = originRect.right + (float)this.radius;
                break;
            }
            case 8: {
                rect.top = originRect.top - (float)this.radius;
                rect.left = originRect.left - (float)this.radius;
            }
        }
        return rect;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof GlideCorner ? this.radius == ((GlideCorner)((Object)other)).radius && this.position == ((GlideCorner)((Object)other)).position : false;
    }

    public int hashCode() {
        return Util.hashCode((int)ID.hashCode(), (int)Util.hashCode((int)this.radius, (int)this.position.getPos()));
    }

    public void updateDiskCacheKey(@NotNull MessageDigest messageDigest) {
        Intrinsics.checkNotNullParameter((Object)messageDigest, (String)"messageDigest");
        messageDigest.update(ID_BYTES);
        int value = this.position.getPos() * 10000 + this.radius;
        byte[] radiusData = ByteBuffer.allocate(5).putInt(value).array();
        messageDigest.update(radiusData);
    }

    static {
        String string = ID;
        Charset charset = Key.CHARSET;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"CHARSET");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        ID_BYTES = byArray;
        BITMAP_DRAWABLE_LOCK = new NoLock();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0004H\u0016\u00a8\u0006\u000f"}, d2={"Ldev/hitools/utils/core/glide/corner/GlideCorner$NoLock;", "Ljava/util/concurrent/locks/Lock;", "()V", "lock", "", "lockInterruptibly", "newCondition", "Ljava/util/concurrent/locks/Condition;", "tryLock", "", "time", "", "unit", "Ljava/util/concurrent/TimeUnit;", "unlock", "utils-core_release"})
    private static final class NoLock
    implements Lock {
        @Override
        public void lock() {
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
        }

        @Override
        public boolean tryLock() {
            return true;
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            return true;
        }

        @Override
        public void unlock() {
        }

        @Override
        @NotNull
        public Condition newCondition() {
            throw new UnsupportedOperationException("Should not be called");
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldev/hitools/utils/core/glide/corner/GlideCorner$Companion;", "", "()V", "BITMAP_DRAWABLE_LOCK", "Ldev/hitools/utils/core/glide/corner/GlideCorner$NoLock;", "ID", "", "ID_BYTES", "", "clear", "", "canvas", "Landroid/graphics/Canvas;", "getAlphaSafeBitmap", "Landroid/graphics/Bitmap;", "pool", "Lcom/bumptech/glide/load/engine/bitmap_recycle/BitmapPool;", "maybeAlphaSafe", "getAlphaSafeConfig", "Landroid/graphics/Bitmap$Config;", "inBitmap", "utils-core_release"})
    public static final class Companion {
        private Companion() {
        }

        private final Bitmap.Config getAlphaSafeConfig(Bitmap inBitmap) {
            if (Build.VERSION.SDK_INT >= 26 && Bitmap.Config.RGBA_F16 == inBitmap.getConfig()) {
                return Bitmap.Config.RGBA_F16;
            }
            return Bitmap.Config.ARGB_8888;
        }

        private final Bitmap getAlphaSafeBitmap(BitmapPool pool, Bitmap maybeAlphaSafe) {
            Bitmap.Config safeConfig = this.getAlphaSafeConfig(maybeAlphaSafe);
            if (safeConfig == maybeAlphaSafe.getConfig()) {
                return maybeAlphaSafe;
            }
            Bitmap bitmap = pool.get(maybeAlphaSafe.getWidth(), maybeAlphaSafe.getHeight(), safeConfig);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"pool.get(maybeAlphaSafe.\u2026aSafe.height, safeConfig)");
            Bitmap argbBitmap = bitmap;
            new Canvas(argbBitmap).drawBitmap(maybeAlphaSafe, 0.0f, 0.0f, null);
            return argbBitmap;
        }

        private final void clear(Canvas canvas) {
            canvas.setBitmap(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\r\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Ldev/hitools/utils/core/glide/corner/GlideCorner$Position;", "", "pos", "", "(Ljava/lang/String;II)V", "getPos", "()I", "All", "Top", "Bottom", "Start", "End", "TopStart", "TopEnd", "BottomStart", "BottomEnd", "utils-core_release"})
    public static final class Position
    extends Enum<Position> {
        private final int pos;
        public static final /* enum */ Position All = new Position(0);
        public static final /* enum */ Position Top = new Position(1);
        public static final /* enum */ Position Bottom = new Position(2);
        public static final /* enum */ Position Start = new Position(3);
        public static final /* enum */ Position End = new Position(4);
        public static final /* enum */ Position TopStart = new Position(5);
        public static final /* enum */ Position TopEnd = new Position(6);
        public static final /* enum */ Position BottomStart = new Position(7);
        public static final /* enum */ Position BottomEnd = new Position(8);
        private static final /* synthetic */ Position[] $VALUES;

        private Position(int pos) {
            this.pos = pos;
        }

        public final int getPos() {
            return this.pos;
        }

        public static Position[] values() {
            return (Position[])$VALUES.clone();
        }

        public static Position valueOf(String value) {
            return Enum.valueOf(Position.class, value);
        }

        static {
            $VALUES = positionArray = new Position[]{Position.All, Position.Top, Position.Bottom, Position.Start, Position.End, Position.TopStart, Position.TopEnd, Position.BottomStart, Position.BottomEnd};
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Position.values().length];
            nArray[Position.Top.ordinal()] = 1;
            nArray[Position.Bottom.ordinal()] = 2;
            nArray[Position.Start.ordinal()] = 3;
            nArray[Position.End.ordinal()] = 4;
            nArray[Position.TopStart.ordinal()] = 5;
            nArray[Position.TopEnd.ordinal()] = 6;
            nArray[Position.BottomStart.ordinal()] = 7;
            nArray[Position.BottomEnd.ordinal()] = 8;
            nArray[Position.All.ordinal()] = 9;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

