/*
 * Decompiled with CFR 0.152.
 */
package dev.hitools.utils.core.permission;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import dev.hitools.common.utils.permission.PermissionInfo;
import dev.hitools.utils.kts.ActivityExt;
import dev.hitools.utils.kts.AnyExt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0014J+\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ+\u0010\u0010\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ%\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\u0013JL\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\t2\u001c\b\u0002\u0010\u0015\u001a\u0016\u0012\u0004\u0012\u00020\f\u0018\u00010\u0016j\n\u0012\u0004\u0012\u00020\f\u0018\u0001`\u00172\u001c\b\u0002\u0010\u0018\u001a\u0016\u0012\u0004\u0012\u00020\f\u0018\u00010\u0016j\n\u0012\u0004\u0012\u00020\f\u0018\u0001`\u0017H\u0002J.\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\t2\u001c\b\u0002\u0010\u0015\u001a\u0016\u0012\u0004\u0012\u00020\f\u0018\u00010\u0016j\n\u0012\u0004\u0012\u00020\f\u0018\u0001`\u0017H\u0002\u00a8\u0006\u001b"}, d2={"Ldev/hitools/utils/core/permission/RequestPermissionActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "onRequestPermissionsResult", "requestCode", "", "permissions", "", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "parseResult", "requestPermission", "taskId", "(I[Ljava/lang/String;)V", "requestPermissionFailed", "granted", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "denied", "requestPermissionSuccess", "Companion", "utils-core_release"})
public final class RequestPermissionActivity
extends AppCompatActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int REQUEST_PERMISSION_CODE = 2020;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ActivityExt.INSTANCE.fullWindow((AppCompatActivity)this, false);
        String[] permissions = this.getIntent().getStringArrayExtra("key_request_permissions");
        int taskId = this.getIntent().getIntExtra("key_request_permission_id", 0);
        this.requestPermission(taskId, permissions);
    }

    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        this.parseResult(requestCode, permissions, grantResults);
    }

    private final void requestPermission(int taskId, String[] permissions) {
        if (permissions == null) {
            RequestPermissionActivity.requestPermissionFailed$default(this, taskId, null, null, 6, null);
            return;
        }
        ActivityCompat.requestPermissions((Activity)((Activity)this), (String[])permissions, (int)(2020 + taskId));
    }

    private final void parseResult(int requestCode, String[] permissions, int[] grantResults) {
        int taskId = requestCode - 2020;
        ArrayList<String> granted = new ArrayList<String>();
        ArrayList<String> denied = new ArrayList<String>();
        int n = permissions.length;
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            String permission = permissions[i];
            if (grantResults[i2] == 0) {
                granted.add(permission);
                continue;
            }
            denied.add(permission);
        }
        if (denied.size() <= 0) {
            this.requestPermissionSuccess(taskId, granted);
        } else {
            this.requestPermissionFailed(taskId, granted, denied);
        }
    }

    private final void requestPermissionSuccess(int taskId, ArrayList<String> granted) {
        PermissionInfo info = new PermissionInfo(0);
        info.setGranted((List<String>)granted);
        Intent intent = new Intent("dev.hitools.permission.ACTION_PERMISSION" + taskId);
        intent.putExtra("key_permission_detail_", AnyExt.INSTANCE.toJSON((Object)info));
        LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)((Context)this));
        Intrinsics.checkNotNullExpressionValue((Object)localBroadcastManager, (String)"getInstance(this)");
        LocalBroadcastManager manager = localBroadcastManager;
        manager.sendBroadcast(intent);
        this.finish();
    }

    static /* synthetic */ void requestPermissionSuccess$default(RequestPermissionActivity requestPermissionActivity, int n, ArrayList arrayList, int n2, Object object) {
        if ((n2 & 2) != 0) {
            arrayList = null;
        }
        requestPermissionActivity.requestPermissionSuccess(n, arrayList);
    }

    private final void requestPermissionFailed(int taskId, ArrayList<String> granted, ArrayList<String> denied) {
        PermissionInfo info = new PermissionInfo(1);
        info.setGranted((List<String>)granted);
        info.setDenied((List<String>)denied);
        Intent intent = new Intent("dev.hitools.permission.ACTION_PERMISSION" + taskId);
        intent.putExtra("key_permission_detail_", AnyExt.INSTANCE.toJSON((Object)info));
        LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)((Context)this));
        Intrinsics.checkNotNullExpressionValue((Object)localBroadcastManager, (String)"getInstance(this)");
        LocalBroadcastManager manager = localBroadcastManager;
        manager.sendBroadcast(intent);
        this.finish();
    }

    static /* synthetic */ void requestPermissionFailed$default(RequestPermissionActivity requestPermissionActivity, int n, ArrayList arrayList, ArrayList arrayList2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            arrayList = null;
        }
        if ((n2 & 4) != 0) {
            arrayList2 = null;
        }
        requestPermissionActivity.requestPermissionFailed(n, arrayList, arrayList2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldev/hitools/utils/core/permission/RequestPermissionActivity$Companion;", "", "()V", "REQUEST_PERMISSION_CODE", "", "utils-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

