/*
 * Decompiled with CFR 0.152.
 */
package dev.hitools.utils.core.textwatcher;

import android.text.Editable;
import android.text.TextWatcher;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J*\u0010\u000b\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J*\u0010\u0014\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ldev/hitools/utils/core/textwatcher/PhoneNumberTextWatcher;", "Landroid/text/TextWatcher;", "spacer", "", "(Ljava/lang/String;)V", "selfChange", "", "afterTextChanged", "", "s", "Landroid/text/Editable;", "beforeTextChanged", "", "start", "", "count", "after", "format", "length", "formatAll", "onTextChanged", "before", "utils-core_release"})
public final class PhoneNumberTextWatcher
implements TextWatcher {
    @NotNull
    private final String spacer;
    private boolean selfChange;

    public PhoneNumberTextWatcher(@NotNull String spacer) {
        Intrinsics.checkNotNullParameter((Object)spacer, (String)"spacer");
        this.spacer = spacer;
    }

    public /* synthetic */ PhoneNumberTextWatcher(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = " ";
        }
        this(string);
    }

    public void afterTextChanged(@Nullable Editable s) {
        if (this.selfChange || s == null) {
            return;
        }
        switch (s.length()) {
            case 4: {
                this.format(s, 4);
                break;
            }
            case 9: {
                this.format(s, 9);
                break;
            }
            case 11: {
                this.formatAll(s);
            }
        }
    }

    public void beforeTextChanged(@Nullable CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(@Nullable CharSequence s, int start, int before, int count) {
    }

    private final void format(Editable s, int length) {
        int start = length - 1;
        this.selfChange = true;
        CharSequence charSequence = (CharSequence)s;
        int n = charSequence.length();
        if (Intrinsics.areEqual((Object)((Object)charSequence.subSequence(start, n)).toString(), (Object)this.spacer)) {
            s.delete(start, length);
        } else {
            s.insert(start, (CharSequence)this.spacer);
        }
        this.selfChange = false;
    }

    private final void formatAll(Editable s) {
        if (!StringsKt.contains$default((CharSequence)((CharSequence)s), (CharSequence)this.spacer, (boolean)false, (int)2, null)) {
            this.selfChange = true;
            s.insert(3, (CharSequence)this.spacer);
            s.insert(8, (CharSequence)this.spacer);
            this.selfChange = false;
        }
    }

    public PhoneNumberTextWatcher() {
        this(null, 1, null);
    }
}

