package io.k8s.api.apiserverinternal.v1alpha1


/** An API server instance reports the version it can decode and the version it encodes objects to when persisting objects in the backend. */
final case class ServerStorageVersion(
  apiServerID : Option[String] = None,
  decodableVersions : Option[Seq[String]] = None,
  encodingVersion : Option[String] = None
) {

  /** Returns a new data with apiServerID set to new value */
  def withApiServerID(value: String) : ServerStorageVersion = copy(apiServerID = Some(value))
  /** if apiServerID has a value, transforms to the result of function*/
  def mapApiServerID(f: String => String) : ServerStorageVersion = copy(apiServerID = apiServerID.map(f))

  /** Returns a new data with decodableVersions set to new value */
  def withDecodableVersions(value: Seq[String]) : ServerStorageVersion = copy(decodableVersions = Some(value))
  /** Appends new values to decodableVersions */
  def addDecodableVersions(newValues: String*) : ServerStorageVersion = copy(decodableVersions = Some(decodableVersions.fold(newValues)(_ ++ newValues)))
  /** if decodableVersions has a value, transforms to the result of function*/
  def mapDecodableVersions(f: Seq[String] => Seq[String]) : ServerStorageVersion = copy(decodableVersions = decodableVersions.map(f))

  /** Returns a new data with encodingVersion set to new value */
  def withEncodingVersion(value: String) : ServerStorageVersion = copy(encodingVersion = Some(value))
  /** if encodingVersion has a value, transforms to the result of function*/
  def mapEncodingVersion(f: String => String) : ServerStorageVersion = copy(encodingVersion = encodingVersion.map(f))
}

