package io.k8s.api.apiserverinternal.v1alpha1

import dev.hnaderi.k8s._

/** A list of StorageVersions. */
final case class StorageVersionList(
  items : Seq[io.k8s.api.apiserverinternal.v1alpha1.StorageVersion],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("internal.apiserver.k8s.io", "StorageVersionList", "v1alpha1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.apiserverinternal.v1alpha1.StorageVersion]) : StorageVersionList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.apiserverinternal.v1alpha1.StorageVersion*) : StorageVersionList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.apiserverinternal.v1alpha1.StorageVersion] => Seq[io.k8s.api.apiserverinternal.v1alpha1.StorageVersion]) : StorageVersionList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : StorageVersionList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : StorageVersionList = copy(metadata = metadata.map(f))
}

