package io.k8s.api.apps.v1

import dev.hnaderi.k8s._

/** ControllerRevision implements an immutable snapshot of state data. Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers. */
final case class ControllerRevision(
  revision : Int,
  data : Option[io.k8s.apimachinery.pkg.runtime.RawExtension] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("apps", "ControllerRevision", "v1")


  /** Returns a new data with revision set to new value */
  def withRevision(value: Int) : ControllerRevision = copy(revision = value)
  /** transforms revision to result of function */
  def mapRevision(f: Int => Int) : ControllerRevision = copy(revision = f(revision))

  /** Returns a new data with data set to new value */
  def withData(value: io.k8s.apimachinery.pkg.runtime.RawExtension) : ControllerRevision = copy(data = Some(value))
  /** if data has a value, transforms to the result of function*/
  def mapData(f: io.k8s.apimachinery.pkg.runtime.RawExtension => io.k8s.apimachinery.pkg.runtime.RawExtension) : ControllerRevision = copy(data = data.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ControllerRevision = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ControllerRevision = copy(metadata = metadata.map(f))
}

