package io.k8s.api.apps.v1


/** DaemonSetUpdateStrategy is a struct used to control the update strategy for a DaemonSet. */
final case class DaemonSetUpdateStrategy(
  rollingUpdate : Option[io.k8s.api.apps.v1.RollingUpdateDaemonSet] = None,
  `type` : Option[String] = None
) {

  /** Returns a new data with rollingUpdate set to new value */
  def withRollingUpdate(value: io.k8s.api.apps.v1.RollingUpdateDaemonSet) : DaemonSetUpdateStrategy = copy(rollingUpdate = Some(value))
  /** if rollingUpdate has a value, transforms to the result of function*/
  def mapRollingUpdate(f: io.k8s.api.apps.v1.RollingUpdateDaemonSet => io.k8s.api.apps.v1.RollingUpdateDaemonSet) : DaemonSetUpdateStrategy = copy(rollingUpdate = rollingUpdate.map(f))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : DaemonSetUpdateStrategy = copy(`type` = Some(value))
  /** if `type` has a value, transforms to the result of function*/
  def mapType(f: String => String) : DaemonSetUpdateStrategy = copy(`type` = `type`.map(f))
}

