package io.k8s.api.apps.v1


/** DeploymentStrategy describes how to replace existing pods with new ones. */
final case class DeploymentStrategy(
  rollingUpdate : Option[io.k8s.api.apps.v1.RollingUpdateDeployment] = None,
  `type` : Option[String] = None
) {

  /** Returns a new data with rollingUpdate set to new value */
  def withRollingUpdate(value: io.k8s.api.apps.v1.RollingUpdateDeployment) : DeploymentStrategy = copy(rollingUpdate = Some(value))
  /** if rollingUpdate has a value, transforms to the result of function*/
  def mapRollingUpdate(f: io.k8s.api.apps.v1.RollingUpdateDeployment => io.k8s.api.apps.v1.RollingUpdateDeployment) : DeploymentStrategy = copy(rollingUpdate = rollingUpdate.map(f))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : DeploymentStrategy = copy(`type` = Some(value))
  /** if `type` has a value, transforms to the result of function*/
  def mapType(f: String => String) : DeploymentStrategy = copy(`type` = `type`.map(f))
}

