package io.k8s.api.apps.v1

import dev.hnaderi.k8s._

/** ReplicaSet ensures that a specified number of pod replicas are running at any given time. */
final case class ReplicaSet(
  status : Option[io.k8s.api.apps.v1.ReplicaSetStatus] = None,
  spec : Option[io.k8s.api.apps.v1.ReplicaSetSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("apps", "ReplicaSet", "v1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.apps.v1.ReplicaSetStatus) : ReplicaSet = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.apps.v1.ReplicaSetStatus => io.k8s.api.apps.v1.ReplicaSetStatus) : ReplicaSet = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.apps.v1.ReplicaSetSpec) : ReplicaSet = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.apps.v1.ReplicaSetSpec => io.k8s.api.apps.v1.ReplicaSetSpec) : ReplicaSet = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ReplicaSet = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ReplicaSet = copy(metadata = metadata.map(f))
}

