package io.k8s.api.apps.v1


/** StatefulSetPersistentVolumeClaimRetentionPolicy describes the policy used for PVCs created from the StatefulSet VolumeClaimTemplates. */
final case class StatefulSetPersistentVolumeClaimRetentionPolicy(
  whenDeleted : Option[String] = None,
  whenScaled : Option[String] = None
) {

  /** Returns a new data with whenDeleted set to new value */
  def withWhenDeleted(value: String) : StatefulSetPersistentVolumeClaimRetentionPolicy = copy(whenDeleted = Some(value))
  /** if whenDeleted has a value, transforms to the result of function*/
  def mapWhenDeleted(f: String => String) : StatefulSetPersistentVolumeClaimRetentionPolicy = copy(whenDeleted = whenDeleted.map(f))

  /** Returns a new data with whenScaled set to new value */
  def withWhenScaled(value: String) : StatefulSetPersistentVolumeClaimRetentionPolicy = copy(whenScaled = Some(value))
  /** if whenScaled has a value, transforms to the result of function*/
  def mapWhenScaled(f: String => String) : StatefulSetPersistentVolumeClaimRetentionPolicy = copy(whenScaled = whenScaled.map(f))
}

