package io.k8s.api.authorization.v1


/** ResourceAttributes includes the authorization attributes available for resource requests to the Authorizer interface */
final case class ResourceAttributes(
  name : Option[String] = None,
  version : Option[String] = None,
  resource : Option[String] = None,
  verb : Option[String] = None,
  group : Option[String] = None,
  subresource : Option[String] = None,
  namespace : Option[String] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : ResourceAttributes = copy(name = Some(value))
  /** if name has a value, transforms to the result of function*/
  def mapName(f: String => String) : ResourceAttributes = copy(name = name.map(f))

  /** Returns a new data with version set to new value */
  def withVersion(value: String) : ResourceAttributes = copy(version = Some(value))
  /** if version has a value, transforms to the result of function*/
  def mapVersion(f: String => String) : ResourceAttributes = copy(version = version.map(f))

  /** Returns a new data with resource set to new value */
  def withResource(value: String) : ResourceAttributes = copy(resource = Some(value))
  /** if resource has a value, transforms to the result of function*/
  def mapResource(f: String => String) : ResourceAttributes = copy(resource = resource.map(f))

  /** Returns a new data with verb set to new value */
  def withVerb(value: String) : ResourceAttributes = copy(verb = Some(value))
  /** if verb has a value, transforms to the result of function*/
  def mapVerb(f: String => String) : ResourceAttributes = copy(verb = verb.map(f))

  /** Returns a new data with group set to new value */
  def withGroup(value: String) : ResourceAttributes = copy(group = Some(value))
  /** if group has a value, transforms to the result of function*/
  def mapGroup(f: String => String) : ResourceAttributes = copy(group = group.map(f))

  /** Returns a new data with subresource set to new value */
  def withSubresource(value: String) : ResourceAttributes = copy(subresource = Some(value))
  /** if subresource has a value, transforms to the result of function*/
  def mapSubresource(f: String => String) : ResourceAttributes = copy(subresource = subresource.map(f))

  /** Returns a new data with namespace set to new value */
  def withNamespace(value: String) : ResourceAttributes = copy(namespace = Some(value))
  /** if namespace has a value, transforms to the result of function*/
  def mapNamespace(f: String => String) : ResourceAttributes = copy(namespace = namespace.map(f))
}

