package io.k8s.api.authorization.v1

import dev.hnaderi.k8s._

/** SelfSubjectRulesReview enumerates the set of actions the current user can perform within a namespace. The returned list of actions may be incomplete depending on the server's authorization mode, and any errors experienced during the evaluation. SelfSubjectRulesReview should be used by UIs to show/hide actions, or to quickly let an end user reason about their permissions. It should NOT Be used by external systems to drive authorization decisions as this raises confused deputy, cache lifetime/revocation, and correctness concerns. SubjectAccessReview, and LocalAccessReview are the correct way to defer authorization decisions to the API server. */
final case class SelfSubjectRulesReview(
  spec : io.k8s.api.authorization.v1.SelfSubjectRulesReviewSpec,
  status : Option[io.k8s.api.authorization.v1.SubjectRulesReviewStatus] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("authorization.k8s.io", "SelfSubjectRulesReview", "v1")


  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.authorization.v1.SelfSubjectRulesReviewSpec) : SelfSubjectRulesReview = copy(spec = value)
  /** transforms spec to result of function */
  def mapSpec(f: io.k8s.api.authorization.v1.SelfSubjectRulesReviewSpec => io.k8s.api.authorization.v1.SelfSubjectRulesReviewSpec) : SelfSubjectRulesReview = copy(spec = f(spec))

  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.authorization.v1.SubjectRulesReviewStatus) : SelfSubjectRulesReview = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.authorization.v1.SubjectRulesReviewStatus => io.k8s.api.authorization.v1.SubjectRulesReviewStatus) : SelfSubjectRulesReview = copy(status = status.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : SelfSubjectRulesReview = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : SelfSubjectRulesReview = copy(metadata = metadata.map(f))
}

