package io.k8s.api.authorization.v1

import dev.hnaderi.k8s._

/** SubjectAccessReview checks whether or not a user or group can perform an action. */
final case class SubjectAccessReview(
  spec : io.k8s.api.authorization.v1.SubjectAccessReviewSpec,
  status : Option[io.k8s.api.authorization.v1.SubjectAccessReviewStatus] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("authorization.k8s.io", "SubjectAccessReview", "v1")


  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.authorization.v1.SubjectAccessReviewSpec) : SubjectAccessReview = copy(spec = value)
  /** transforms spec to result of function */
  def mapSpec(f: io.k8s.api.authorization.v1.SubjectAccessReviewSpec => io.k8s.api.authorization.v1.SubjectAccessReviewSpec) : SubjectAccessReview = copy(spec = f(spec))

  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.authorization.v1.SubjectAccessReviewStatus) : SubjectAccessReview = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.authorization.v1.SubjectAccessReviewStatus => io.k8s.api.authorization.v1.SubjectAccessReviewStatus) : SubjectAccessReview = copy(status = status.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : SubjectAccessReview = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : SubjectAccessReview = copy(metadata = metadata.map(f))
}

