package io.k8s.api.autoscaling.v1


/** specification of a horizontal pod autoscaler. */
final case class HorizontalPodAutoscalerSpec(
  maxReplicas : Int,
  scaleTargetRef : io.k8s.api.autoscaling.v1.CrossVersionObjectReference,
  minReplicas : Option[Int] = None,
  targetCPUUtilizationPercentage : Option[Int] = None
) {

  /** Returns a new data with maxReplicas set to new value */
  def withMaxReplicas(value: Int) : HorizontalPodAutoscalerSpec = copy(maxReplicas = value)
  /** transforms maxReplicas to result of function */
  def mapMaxReplicas(f: Int => Int) : HorizontalPodAutoscalerSpec = copy(maxReplicas = f(maxReplicas))

  /** Returns a new data with scaleTargetRef set to new value */
  def withScaleTargetRef(value: io.k8s.api.autoscaling.v1.CrossVersionObjectReference) : HorizontalPodAutoscalerSpec = copy(scaleTargetRef = value)
  /** transforms scaleTargetRef to result of function */
  def mapScaleTargetRef(f: io.k8s.api.autoscaling.v1.CrossVersionObjectReference => io.k8s.api.autoscaling.v1.CrossVersionObjectReference) : HorizontalPodAutoscalerSpec = copy(scaleTargetRef = f(scaleTargetRef))

  /** Returns a new data with minReplicas set to new value */
  def withMinReplicas(value: Int) : HorizontalPodAutoscalerSpec = copy(minReplicas = Some(value))
  /** if minReplicas has a value, transforms to the result of function*/
  def mapMinReplicas(f: Int => Int) : HorizontalPodAutoscalerSpec = copy(minReplicas = minReplicas.map(f))

  /** Returns a new data with targetCPUUtilizationPercentage set to new value */
  def withTargetCPUUtilizationPercentage(value: Int) : HorizontalPodAutoscalerSpec = copy(targetCPUUtilizationPercentage = Some(value))
  /** if targetCPUUtilizationPercentage has a value, transforms to the result of function*/
  def mapTargetCPUUtilizationPercentage(f: Int => Int) : HorizontalPodAutoscalerSpec = copy(targetCPUUtilizationPercentage = targetCPUUtilizationPercentage.map(f))
}

