package io.k8s.api.autoscaling.v2


/** MetricSpec specifies how to scale based on a single metric (only `type` and one other matching field should be set at once). */
final case class MetricSpec(
  `type` : String,
  `object` : Option[io.k8s.api.autoscaling.v2.ObjectMetricSource] = None,
  external : Option[io.k8s.api.autoscaling.v2.ExternalMetricSource] = None,
  containerResource : Option[io.k8s.api.autoscaling.v2.ContainerResourceMetricSource] = None,
  resource : Option[io.k8s.api.autoscaling.v2.ResourceMetricSource] = None,
  pods : Option[io.k8s.api.autoscaling.v2.PodsMetricSource] = None
) {

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : MetricSpec = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : MetricSpec = copy(`type` = f(`type`))

  /** Returns a new data with `object` set to new value */
  def withObject(value: io.k8s.api.autoscaling.v2.ObjectMetricSource) : MetricSpec = copy(`object` = Some(value))
  /** if `object` has a value, transforms to the result of function*/
  def mapObject(f: io.k8s.api.autoscaling.v2.ObjectMetricSource => io.k8s.api.autoscaling.v2.ObjectMetricSource) : MetricSpec = copy(`object` = `object`.map(f))

  /** Returns a new data with external set to new value */
  def withExternal(value: io.k8s.api.autoscaling.v2.ExternalMetricSource) : MetricSpec = copy(external = Some(value))
  /** if external has a value, transforms to the result of function*/
  def mapExternal(f: io.k8s.api.autoscaling.v2.ExternalMetricSource => io.k8s.api.autoscaling.v2.ExternalMetricSource) : MetricSpec = copy(external = external.map(f))

  /** Returns a new data with containerResource set to new value */
  def withContainerResource(value: io.k8s.api.autoscaling.v2.ContainerResourceMetricSource) : MetricSpec = copy(containerResource = Some(value))
  /** if containerResource has a value, transforms to the result of function*/
  def mapContainerResource(f: io.k8s.api.autoscaling.v2.ContainerResourceMetricSource => io.k8s.api.autoscaling.v2.ContainerResourceMetricSource) : MetricSpec = copy(containerResource = containerResource.map(f))

  /** Returns a new data with resource set to new value */
  def withResource(value: io.k8s.api.autoscaling.v2.ResourceMetricSource) : MetricSpec = copy(resource = Some(value))
  /** if resource has a value, transforms to the result of function*/
  def mapResource(f: io.k8s.api.autoscaling.v2.ResourceMetricSource => io.k8s.api.autoscaling.v2.ResourceMetricSource) : MetricSpec = copy(resource = resource.map(f))

  /** Returns a new data with pods set to new value */
  def withPods(value: io.k8s.api.autoscaling.v2.PodsMetricSource) : MetricSpec = copy(pods = Some(value))
  /** if pods has a value, transforms to the result of function*/
  def mapPods(f: io.k8s.api.autoscaling.v2.PodsMetricSource => io.k8s.api.autoscaling.v2.PodsMetricSource) : MetricSpec = copy(pods = pods.map(f))
}

