package io.k8s.api.autoscaling.v2


/** ObjectMetricStatus indicates the current value of a metric describing a kubernetes object (for example, hits-per-second on an Ingress object). */
final case class ObjectMetricStatus(
  current : io.k8s.api.autoscaling.v2.MetricValueStatus,
  describedObject : io.k8s.api.autoscaling.v2.CrossVersionObjectReference,
  metric : io.k8s.api.autoscaling.v2.MetricIdentifier
) {

  /** Returns a new data with current set to new value */
  def withCurrent(value: io.k8s.api.autoscaling.v2.MetricValueStatus) : ObjectMetricStatus = copy(current = value)
  /** transforms current to result of function */
  def mapCurrent(f: io.k8s.api.autoscaling.v2.MetricValueStatus => io.k8s.api.autoscaling.v2.MetricValueStatus) : ObjectMetricStatus = copy(current = f(current))

  /** Returns a new data with describedObject set to new value */
  def withDescribedObject(value: io.k8s.api.autoscaling.v2.CrossVersionObjectReference) : ObjectMetricStatus = copy(describedObject = value)
  /** transforms describedObject to result of function */
  def mapDescribedObject(f: io.k8s.api.autoscaling.v2.CrossVersionObjectReference => io.k8s.api.autoscaling.v2.CrossVersionObjectReference) : ObjectMetricStatus = copy(describedObject = f(describedObject))

  /** Returns a new data with metric set to new value */
  def withMetric(value: io.k8s.api.autoscaling.v2.MetricIdentifier) : ObjectMetricStatus = copy(metric = value)
  /** transforms metric to result of function */
  def mapMetric(f: io.k8s.api.autoscaling.v2.MetricIdentifier => io.k8s.api.autoscaling.v2.MetricIdentifier) : ObjectMetricStatus = copy(metric = f(metric))
}

