package io.k8s.api.autoscaling.v2beta2


/** HorizontalPodAutoscalerBehavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively). */
final case class HorizontalPodAutoscalerBehavior(
  scaleDown : Option[io.k8s.api.autoscaling.v2beta2.HPAScalingRules] = None,
  scaleUp : Option[io.k8s.api.autoscaling.v2beta2.HPAScalingRules] = None
) {

  /** Returns a new data with scaleDown set to new value */
  def withScaleDown(value: io.k8s.api.autoscaling.v2beta2.HPAScalingRules) : HorizontalPodAutoscalerBehavior = copy(scaleDown = Some(value))
  /** if scaleDown has a value, transforms to the result of function*/
  def mapScaleDown(f: io.k8s.api.autoscaling.v2beta2.HPAScalingRules => io.k8s.api.autoscaling.v2beta2.HPAScalingRules) : HorizontalPodAutoscalerBehavior = copy(scaleDown = scaleDown.map(f))

  /** Returns a new data with scaleUp set to new value */
  def withScaleUp(value: io.k8s.api.autoscaling.v2beta2.HPAScalingRules) : HorizontalPodAutoscalerBehavior = copy(scaleUp = Some(value))
  /** if scaleUp has a value, transforms to the result of function*/
  def mapScaleUp(f: io.k8s.api.autoscaling.v2beta2.HPAScalingRules => io.k8s.api.autoscaling.v2beta2.HPAScalingRules) : HorizontalPodAutoscalerBehavior = copy(scaleUp = scaleUp.map(f))
}

