package io.k8s.api.batch.v1

import dev.hnaderi.k8s._

/** CronJob represents the configuration of a single cron job. */
final case class CronJob(
  status : Option[io.k8s.api.batch.v1.CronJobStatus] = None,
  spec : Option[io.k8s.api.batch.v1.CronJobSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("batch", "CronJob", "v1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.batch.v1.CronJobStatus) : CronJob = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.batch.v1.CronJobStatus => io.k8s.api.batch.v1.CronJobStatus) : CronJob = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.batch.v1.CronJobSpec) : CronJob = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.batch.v1.CronJobSpec => io.k8s.api.batch.v1.CronJobSpec) : CronJob = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : CronJob = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : CronJob = copy(metadata = metadata.map(f))
}

