package io.k8s.api.batch.v1


/** CronJobSpec describes how the job execution will look like and when it will actually run. */
final case class CronJobSpec(
  schedule : String,
  jobTemplate : io.k8s.api.batch.v1.JobTemplateSpec,
  startingDeadlineSeconds : Option[Int] = None,
  concurrencyPolicy : Option[String] = None,
  failedJobsHistoryLimit : Option[Int] = None,
  successfulJobsHistoryLimit : Option[Int] = None,
  suspend : Option[Boolean] = None,
  timeZone : Option[String] = None
) {

  /** Returns a new data with schedule set to new value */
  def withSchedule(value: String) : CronJobSpec = copy(schedule = value)
  /** transforms schedule to result of function */
  def mapSchedule(f: String => String) : CronJobSpec = copy(schedule = f(schedule))

  /** Returns a new data with jobTemplate set to new value */
  def withJobTemplate(value: io.k8s.api.batch.v1.JobTemplateSpec) : CronJobSpec = copy(jobTemplate = value)
  /** transforms jobTemplate to result of function */
  def mapJobTemplate(f: io.k8s.api.batch.v1.JobTemplateSpec => io.k8s.api.batch.v1.JobTemplateSpec) : CronJobSpec = copy(jobTemplate = f(jobTemplate))

  /** Returns a new data with startingDeadlineSeconds set to new value */
  def withStartingDeadlineSeconds(value: Int) : CronJobSpec = copy(startingDeadlineSeconds = Some(value))
  /** if startingDeadlineSeconds has a value, transforms to the result of function*/
  def mapStartingDeadlineSeconds(f: Int => Int) : CronJobSpec = copy(startingDeadlineSeconds = startingDeadlineSeconds.map(f))

  /** Returns a new data with concurrencyPolicy set to new value */
  def withConcurrencyPolicy(value: String) : CronJobSpec = copy(concurrencyPolicy = Some(value))
  /** if concurrencyPolicy has a value, transforms to the result of function*/
  def mapConcurrencyPolicy(f: String => String) : CronJobSpec = copy(concurrencyPolicy = concurrencyPolicy.map(f))

  /** Returns a new data with failedJobsHistoryLimit set to new value */
  def withFailedJobsHistoryLimit(value: Int) : CronJobSpec = copy(failedJobsHistoryLimit = Some(value))
  /** if failedJobsHistoryLimit has a value, transforms to the result of function*/
  def mapFailedJobsHistoryLimit(f: Int => Int) : CronJobSpec = copy(failedJobsHistoryLimit = failedJobsHistoryLimit.map(f))

  /** Returns a new data with successfulJobsHistoryLimit set to new value */
  def withSuccessfulJobsHistoryLimit(value: Int) : CronJobSpec = copy(successfulJobsHistoryLimit = Some(value))
  /** if successfulJobsHistoryLimit has a value, transforms to the result of function*/
  def mapSuccessfulJobsHistoryLimit(f: Int => Int) : CronJobSpec = copy(successfulJobsHistoryLimit = successfulJobsHistoryLimit.map(f))

  /** Returns a new data with suspend set to new value */
  def withSuspend(value: Boolean) : CronJobSpec = copy(suspend = Some(value))
  /** if suspend has a value, transforms to the result of function*/
  def mapSuspend(f: Boolean => Boolean) : CronJobSpec = copy(suspend = suspend.map(f))

  /** Returns a new data with timeZone set to new value */
  def withTimeZone(value: String) : CronJobSpec = copy(timeZone = Some(value))
  /** if timeZone has a value, transforms to the result of function*/
  def mapTimeZone(f: String => String) : CronJobSpec = copy(timeZone = timeZone.map(f))
}

