package io.k8s.api.batch.v1


/** CronJobStatus represents the current state of a cron job. */
final case class CronJobStatus(
  active : Option[Seq[io.k8s.api.core.v1.ObjectReference]] = None,
  lastScheduleTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  lastSuccessfulTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None
) {

  /** Returns a new data with active set to new value */
  def withActive(value: Seq[io.k8s.api.core.v1.ObjectReference]) : CronJobStatus = copy(active = Some(value))
  /** Appends new values to active */
  def addActive(newValues: io.k8s.api.core.v1.ObjectReference*) : CronJobStatus = copy(active = Some(active.fold(newValues)(_ ++ newValues)))
  /** if active has a value, transforms to the result of function*/
  def mapActive(f: Seq[io.k8s.api.core.v1.ObjectReference] => Seq[io.k8s.api.core.v1.ObjectReference]) : CronJobStatus = copy(active = active.map(f))

  /** Returns a new data with lastScheduleTime set to new value */
  def withLastScheduleTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : CronJobStatus = copy(lastScheduleTime = Some(value))
  /** if lastScheduleTime has a value, transforms to the result of function*/
  def mapLastScheduleTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : CronJobStatus = copy(lastScheduleTime = lastScheduleTime.map(f))

  /** Returns a new data with lastSuccessfulTime set to new value */
  def withLastSuccessfulTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : CronJobStatus = copy(lastSuccessfulTime = Some(value))
  /** if lastSuccessfulTime has a value, transforms to the result of function*/
  def mapLastSuccessfulTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : CronJobStatus = copy(lastSuccessfulTime = lastSuccessfulTime.map(f))
}

