package io.k8s.api.batch.v1

import dev.hnaderi.k8s._

/** Job represents the configuration of a single job. */
final case class Job(
  status : Option[io.k8s.api.batch.v1.JobStatus] = None,
  spec : Option[io.k8s.api.batch.v1.JobSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("batch", "Job", "v1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.batch.v1.JobStatus) : Job = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.batch.v1.JobStatus => io.k8s.api.batch.v1.JobStatus) : Job = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.batch.v1.JobSpec) : Job = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.batch.v1.JobSpec => io.k8s.api.batch.v1.JobSpec) : Job = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Job = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Job = copy(metadata = metadata.map(f))
}

