package io.k8s.api.batch.v1


/** JobTemplateSpec describes the data a Job should have when created from a template */
final case class JobTemplateSpec(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec : Option[io.k8s.api.batch.v1.JobSpec] = None
) {

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : JobTemplateSpec = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : JobTemplateSpec = copy(metadata = metadata.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.batch.v1.JobSpec) : JobTemplateSpec = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.batch.v1.JobSpec => io.k8s.api.batch.v1.JobSpec) : JobTemplateSpec = copy(spec = spec.map(f))
}

