package io.k8s.api.certificates.v1


/** CertificateSigningRequestStatus contains conditions used to indicate approved/denied/failed status of the request, and the issued certificate. */
final case class CertificateSigningRequestStatus(
  certificate : Option[String] = None,
  conditions : Option[Seq[io.k8s.api.certificates.v1.CertificateSigningRequestCondition]] = None
) {

  /** Returns a new data with certificate set to new value */
  def withCertificate(value: String) : CertificateSigningRequestStatus = copy(certificate = Some(value))
  /** if certificate has a value, transforms to the result of function*/
  def mapCertificate(f: String => String) : CertificateSigningRequestStatus = copy(certificate = certificate.map(f))

  /** Returns a new data with conditions set to new value */
  def withConditions(value: Seq[io.k8s.api.certificates.v1.CertificateSigningRequestCondition]) : CertificateSigningRequestStatus = copy(conditions = Some(value))
  /** Appends new values to conditions */
  def addConditions(newValues: io.k8s.api.certificates.v1.CertificateSigningRequestCondition*) : CertificateSigningRequestStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))
  /** if conditions has a value, transforms to the result of function*/
  def mapConditions(f: Seq[io.k8s.api.certificates.v1.CertificateSigningRequestCondition] => Seq[io.k8s.api.certificates.v1.CertificateSigningRequestCondition]) : CertificateSigningRequestStatus = copy(conditions = conditions.map(f))
}

