package io.k8s.api.core.v1


/** AttachedVolume describes a volume attached to a node */
final case class AttachedVolume(
  devicePath : String,
  name : String
) {

  /** Returns a new data with devicePath set to new value */
  def withDevicePath(value: String) : AttachedVolume = copy(devicePath = value)
  /** transforms devicePath to result of function */
  def mapDevicePath(f: String => String) : AttachedVolume = copy(devicePath = f(devicePath))

  /** Returns a new data with name set to new value */
  def withName(value: String) : AttachedVolume = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : AttachedVolume = copy(name = f(name))
}

