package io.k8s.api.core.v1


/** AzureFile represents an Azure File Service mount on the host and bind mount to the pod. */
final case class AzureFileVolumeSource(
  secretName : String,
  shareName : String,
  readOnly : Option[Boolean] = None
) {

  /** Returns a new data with secretName set to new value */
  def withSecretName(value: String) : AzureFileVolumeSource = copy(secretName = value)
  /** transforms secretName to result of function */
  def mapSecretName(f: String => String) : AzureFileVolumeSource = copy(secretName = f(secretName))

  /** Returns a new data with shareName set to new value */
  def withShareName(value: String) : AzureFileVolumeSource = copy(shareName = value)
  /** transforms shareName to result of function */
  def mapShareName(f: String => String) : AzureFileVolumeSource = copy(shareName = f(shareName))

  /** Returns a new data with readOnly set to new value */
  def withReadOnly(value: Boolean) : AzureFileVolumeSource = copy(readOnly = Some(value))
  /** if readOnly has a value, transforms to the result of function*/
  def mapReadOnly(f: Boolean => Boolean) : AzureFileVolumeSource = copy(readOnly = readOnly.map(f))
}

