package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** Binding ties one object to another; for example, a pod is bound to a node by a scheduler. Deprecated in 1.7, please use the bindings subresource of pods instead. */
final case class Binding(
  target : io.k8s.api.core.v1.ObjectReference,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "Binding", "v1")


  /** Returns a new data with target set to new value */
  def withTarget(value: io.k8s.api.core.v1.ObjectReference) : Binding = copy(target = value)
  /** transforms target to result of function */
  def mapTarget(f: io.k8s.api.core.v1.ObjectReference => io.k8s.api.core.v1.ObjectReference) : Binding = copy(target = f(target))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Binding = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Binding = copy(metadata = metadata.map(f))
}

