package io.k8s.api.core.v1


/** Represents a source location of a volume to mount, managed by an external CSI driver */
final case class CSIVolumeSource(
  driver : String,
  readOnly : Option[Boolean] = None,
  fsType : Option[String] = None,
  volumeAttributes : Option[Map[String, String]] = None,
  nodePublishSecretRef : Option[io.k8s.api.core.v1.LocalObjectReference] = None
) {

  /** Returns a new data with driver set to new value */
  def withDriver(value: String) : CSIVolumeSource = copy(driver = value)
  /** transforms driver to result of function */
  def mapDriver(f: String => String) : CSIVolumeSource = copy(driver = f(driver))

  /** Returns a new data with readOnly set to new value */
  def withReadOnly(value: Boolean) : CSIVolumeSource = copy(readOnly = Some(value))
  /** if readOnly has a value, transforms to the result of function*/
  def mapReadOnly(f: Boolean => Boolean) : CSIVolumeSource = copy(readOnly = readOnly.map(f))

  /** Returns a new data with fsType set to new value */
  def withFsType(value: String) : CSIVolumeSource = copy(fsType = Some(value))
  /** if fsType has a value, transforms to the result of function*/
  def mapFsType(f: String => String) : CSIVolumeSource = copy(fsType = fsType.map(f))

  /** Returns a new data with volumeAttributes set to new value */
  def withVolumeAttributes(value: Map[String, String]) : CSIVolumeSource = copy(volumeAttributes = Some(value))
  /** Adds new values to volumeAttributes */
  def addVolumeAttributes(newValues: (String, String)*) : CSIVolumeSource = copy(volumeAttributes = Some(volumeAttributes.fold(newValues.toMap)(_ ++ newValues)))
  /** if volumeAttributes has a value, transforms to the result of function*/
  def mapVolumeAttributes(f: Map[String, String] => Map[String, String]) : CSIVolumeSource = copy(volumeAttributes = volumeAttributes.map(f))

  /** Returns a new data with nodePublishSecretRef set to new value */
  def withNodePublishSecretRef(value: io.k8s.api.core.v1.LocalObjectReference) : CSIVolumeSource = copy(nodePublishSecretRef = Some(value))
  /** if nodePublishSecretRef has a value, transforms to the result of function*/
  def mapNodePublishSecretRef(f: io.k8s.api.core.v1.LocalObjectReference => io.k8s.api.core.v1.LocalObjectReference) : CSIVolumeSource = copy(nodePublishSecretRef = nodePublishSecretRef.map(f))
}

