package io.k8s.api.core.v1


/** ConfigMapEnvSource selects a ConfigMap to populate the environment variables with.

The contents of the target ConfigMap's Data field will represent the key-value pairs as environment variables. */
final case class ConfigMapEnvSource(
  name : Option[String] = None,
  optional : Option[Boolean] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : ConfigMapEnvSource = copy(name = Some(value))
  /** if name has a value, transforms to the result of function*/
  def mapName(f: String => String) : ConfigMapEnvSource = copy(name = name.map(f))

  /** Returns a new data with optional set to new value */
  def withOptional(value: Boolean) : ConfigMapEnvSource = copy(optional = Some(value))
  /** if optional has a value, transforms to the result of function*/
  def mapOptional(f: Boolean => Boolean) : ConfigMapEnvSource = copy(optional = optional.map(f))
}

