package io.k8s.api.core.v1


/** ConfigMapNodeConfigSource contains the information to reference a ConfigMap as a config source for the Node. This API is deprecated since 1.22: https://git.k8s.io/enhancements/keps/sig-node/281-dynamic-kubelet-configuration */
final case class ConfigMapNodeConfigSource(
  name : String,
  kubeletConfigKey : String,
  namespace : String,
  resourceVersion : Option[String] = None,
  uid : Option[String] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : ConfigMapNodeConfigSource = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : ConfigMapNodeConfigSource = copy(name = f(name))

  /** Returns a new data with kubeletConfigKey set to new value */
  def withKubeletConfigKey(value: String) : ConfigMapNodeConfigSource = copy(kubeletConfigKey = value)
  /** transforms kubeletConfigKey to result of function */
  def mapKubeletConfigKey(f: String => String) : ConfigMapNodeConfigSource = copy(kubeletConfigKey = f(kubeletConfigKey))

  /** Returns a new data with namespace set to new value */
  def withNamespace(value: String) : ConfigMapNodeConfigSource = copy(namespace = value)
  /** transforms namespace to result of function */
  def mapNamespace(f: String => String) : ConfigMapNodeConfigSource = copy(namespace = f(namespace))

  /** Returns a new data with resourceVersion set to new value */
  def withResourceVersion(value: String) : ConfigMapNodeConfigSource = copy(resourceVersion = Some(value))
  /** if resourceVersion has a value, transforms to the result of function*/
  def mapResourceVersion(f: String => String) : ConfigMapNodeConfigSource = copy(resourceVersion = resourceVersion.map(f))

  /** Returns a new data with uid set to new value */
  def withUid(value: String) : ConfigMapNodeConfigSource = copy(uid = Some(value))
  /** if uid has a value, transforms to the result of function*/
  def mapUid(f: String => String) : ConfigMapNodeConfigSource = copy(uid = uid.map(f))
}

