package io.k8s.api.core.v1


/** ContainerState holds a possible state of container. Only one of its members may be specified. If none of them is specified, the default one is ContainerStateWaiting. */
final case class ContainerState(
  running : Option[io.k8s.api.core.v1.ContainerStateRunning] = None,
  terminated : Option[io.k8s.api.core.v1.ContainerStateTerminated] = None,
  waiting : Option[io.k8s.api.core.v1.ContainerStateWaiting] = None
) {

  /** Returns a new data with running set to new value */
  def withRunning(value: io.k8s.api.core.v1.ContainerStateRunning) : ContainerState = copy(running = Some(value))
  /** if running has a value, transforms to the result of function*/
  def mapRunning(f: io.k8s.api.core.v1.ContainerStateRunning => io.k8s.api.core.v1.ContainerStateRunning) : ContainerState = copy(running = running.map(f))

  /** Returns a new data with terminated set to new value */
  def withTerminated(value: io.k8s.api.core.v1.ContainerStateTerminated) : ContainerState = copy(terminated = Some(value))
  /** if terminated has a value, transforms to the result of function*/
  def mapTerminated(f: io.k8s.api.core.v1.ContainerStateTerminated => io.k8s.api.core.v1.ContainerStateTerminated) : ContainerState = copy(terminated = terminated.map(f))

  /** Returns a new data with waiting set to new value */
  def withWaiting(value: io.k8s.api.core.v1.ContainerStateWaiting) : ContainerState = copy(waiting = Some(value))
  /** if waiting has a value, transforms to the result of function*/
  def mapWaiting(f: io.k8s.api.core.v1.ContainerStateWaiting => io.k8s.api.core.v1.ContainerStateWaiting) : ContainerState = copy(waiting = waiting.map(f))
}

