package io.k8s.api.core.v1


/** ContainerStateRunning is a running state of a container. */
final case class ContainerStateRunning(
  startedAt : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None
) {

  /** Returns a new data with startedAt set to new value */
  def withStartedAt(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : ContainerStateRunning = copy(startedAt = Some(value))
  /** if startedAt has a value, transforms to the result of function*/
  def mapStartedAt(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : ContainerStateRunning = copy(startedAt = startedAt.map(f))
}

