package io.k8s.api.core.v1


/** DaemonEndpoint contains information about a single Daemon endpoint. */
final case class DaemonEndpoint(
  Port : Int
) {

  /** Returns a new data with Port set to new value */
  def withPort(value: Int) : DaemonEndpoint = copy(Port = value)
  /** transforms Port to result of function */
  def mapPort(f: Int => Int) : DaemonEndpoint = copy(Port = f(Port))
}

