package io.k8s.api.core.v1


/** DownwardAPIVolumeSource represents a volume containing downward API info. Downward API volumes support ownership management and SELinux relabeling. */
final case class DownwardAPIVolumeSource(
  defaultMode : Option[Int] = None,
  items : Option[Seq[io.k8s.api.core.v1.DownwardAPIVolumeFile]] = None
) {

  /** Returns a new data with defaultMode set to new value */
  def withDefaultMode(value: Int) : DownwardAPIVolumeSource = copy(defaultMode = Some(value))
  /** if defaultMode has a value, transforms to the result of function*/
  def mapDefaultMode(f: Int => Int) : DownwardAPIVolumeSource = copy(defaultMode = defaultMode.map(f))

  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.core.v1.DownwardAPIVolumeFile]) : DownwardAPIVolumeSource = copy(items = Some(value))
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.core.v1.DownwardAPIVolumeFile*) : DownwardAPIVolumeSource = copy(items = Some(items.fold(newValues)(_ ++ newValues)))
  /** if items has a value, transforms to the result of function*/
  def mapItems(f: Seq[io.k8s.api.core.v1.DownwardAPIVolumeFile] => Seq[io.k8s.api.core.v1.DownwardAPIVolumeFile]) : DownwardAPIVolumeSource = copy(items = items.map(f))
}

