package io.k8s.api.core.v1


/** Represents an empty directory for a pod. Empty directory volumes support ownership management and SELinux relabeling. */
final case class EmptyDirVolumeSource(
  medium : Option[String] = None,
  sizeLimit : Option[io.k8s.apimachinery.pkg.api.resource.Quantity] = None
) {

  /** Returns a new data with medium set to new value */
  def withMedium(value: String) : EmptyDirVolumeSource = copy(medium = Some(value))
  /** if medium has a value, transforms to the result of function*/
  def mapMedium(f: String => String) : EmptyDirVolumeSource = copy(medium = medium.map(f))

  /** Returns a new data with sizeLimit set to new value */
  def withSizeLimit(value: io.k8s.apimachinery.pkg.api.resource.Quantity) : EmptyDirVolumeSource = copy(sizeLimit = Some(value))
  /** if sizeLimit has a value, transforms to the result of function*/
  def mapSizeLimit(f: io.k8s.apimachinery.pkg.api.resource.Quantity => io.k8s.apimachinery.pkg.api.resource.Quantity) : EmptyDirVolumeSource = copy(sizeLimit = sizeLimit.map(f))
}

