package io.k8s.api.core.v1


/** EndpointPort is a tuple that describes a single port. */
final case class EndpointPort(
  port : Int,
  appProtocol : Option[String] = None,
  name : Option[String] = None,
  protocol : Option[String] = None
) {

  /** Returns a new data with port set to new value */
  def withPort(value: Int) : EndpointPort = copy(port = value)
  /** transforms port to result of function */
  def mapPort(f: Int => Int) : EndpointPort = copy(port = f(port))

  /** Returns a new data with appProtocol set to new value */
  def withAppProtocol(value: String) : EndpointPort = copy(appProtocol = Some(value))
  /** if appProtocol has a value, transforms to the result of function*/
  def mapAppProtocol(f: String => String) : EndpointPort = copy(appProtocol = appProtocol.map(f))

  /** Returns a new data with name set to new value */
  def withName(value: String) : EndpointPort = copy(name = Some(value))
  /** if name has a value, transforms to the result of function*/
  def mapName(f: String => String) : EndpointPort = copy(name = name.map(f))

  /** Returns a new data with protocol set to new value */
  def withProtocol(value: String) : EndpointPort = copy(protocol = Some(value))
  /** if protocol has a value, transforms to the result of function*/
  def mapProtocol(f: String => String) : EndpointPort = copy(protocol = protocol.map(f))
}

