package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** Endpoints is a collection of endpoints that implement the actual service. Example:

	 Name: "mysvc",
	 Subsets: [
	   {
	     Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
	     Ports: [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
	   },
	   {
	     Addresses: [{"ip": "10.10.3.3"}],
	     Ports: [{"name": "a", "port": 93}, {"name": "b", "port": 76}]
	   },
	] */
final case class Endpoints(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  subsets : Option[Seq[io.k8s.api.core.v1.EndpointSubset]] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "Endpoints", "v1")


  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Endpoints = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Endpoints = copy(metadata = metadata.map(f))

  /** Returns a new data with subsets set to new value */
  def withSubsets(value: Seq[io.k8s.api.core.v1.EndpointSubset]) : Endpoints = copy(subsets = Some(value))
  /** Appends new values to subsets */
  def addSubsets(newValues: io.k8s.api.core.v1.EndpointSubset*) : Endpoints = copy(subsets = Some(subsets.fold(newValues)(_ ++ newValues)))
  /** if subsets has a value, transforms to the result of function*/
  def mapSubsets(f: Seq[io.k8s.api.core.v1.EndpointSubset] => Seq[io.k8s.api.core.v1.EndpointSubset]) : Endpoints = copy(subsets = subsets.map(f))
}

